% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board_folder.R
\name{board_folder}
\alias{board_folder}
\alias{board_local}
\alias{board_temp}
\title{Use a local folder as board}
\usage{
board_folder(path, versioned = FALSE)

board_local(versioned = FALSE)

board_temp(versioned = FALSE)
}
\arguments{
\item{path}{Path to directory to store pins. Will be created if it
doesn't already exist.}

\item{versioned}{Should this board be registered with support for versions?}
}
\description{
\itemize{
\item \code{board_folder()} creates a board inside a folder. You can use this to
share files by using a folder on a shared network drive or inside
a DropBox.
\item \code{board_local()} creates a board in a system data directory. It's useful
if you want to share pins between R sessions on your computer, and you
don't care where the data lives.
\item \code{board_temp()} creates a temporary board that lives in a session
specific temporary directory. It will be automatically deleted once
the current R session ends. It's useful for examples and tests.
}
}
\examples{
# session-specific local board
board <- board_temp()
}
\seealso{
Other boards: 
\code{\link{board_connect}()},
\code{\link{board_url}()}
}
\concept{boards}
