% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log.R
\name{set_log_layout}
\alias{set_log_layout}
\title{Set pipeflow log layout}
\usage{
set_log_layout(layout = c("text", "json"))
}
\arguments{
\item{layout}{Layout name, which at this point can be either 'text' or
'json'.}
}
\value{
invisibly returns a \code{Logger} object
}
\description{
This function provides an easy way to set the basic log
layout of the pipeline logging. For a fine-grained control of the logger,
which you can retrieve via \code{lgr::get_logger("pipeflow")}, see e.g. the
\link[lgr]{logger_config} function from the \link[lgr]{lgr} package.
}
\examples{
p <- Pipeline$new("pipe", data = 1:2)
p$add("add1", \(data = ~data, x = 1) x + data)
p$run()

lg <- set_log_layout("json")
print(lg)

p$run()

set_log_layout("text")
p$run()
}
