% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sim_tral_with_uns_site_model_fun.R
\name{get_sim_tral_with_uns_nsm_fun}
\alias{get_sim_tral_with_uns_nsm_fun}
\title{Get a partially evaluated function
to simulate a true alignment with an unlinked node substitution site model.}
\usage{
get_sim_tral_with_uns_nsm_fun(
  branch_subst_matrix = rep(1, 6),
  node_subst_matrix = 1,
  branch_mutation_rate = 1,
  node_mutation_rate = 1,
  base_frequencies = rep(0.25, 4),
  node_time = 0.001
)
}
\arguments{
\item{branch_subst_matrix}{substitution matrix along the branches.
See, among others, \link[nodeSub]{sim_unlinked} for more details}

\item{node_subst_matrix}{substitution matrix on the nodes.
See, among others, \link[nodeSub]{sim_unlinked} for more details}

\item{branch_mutation_rate}{mutation rate along the branch.
See, among others, \link[nodeSub]{sim_unlinked} for more details}

\item{node_mutation_rate}{mutation rate on the node.
See, among others, \link[nodeSub]{sim_unlinked} for more details}

\item{base_frequencies}{the four base frequencies (a, c, g, t) to be
specified to create the rate matrix (i.e. Q matrix)
used to simulate alignments}

\item{node_time}{amount of time spent at the nodes.
See, among others, \link[nodeSub]{sim_unlinked} for more details}
}
\value{
A partially evaluated function of
\link{sim_tral_with_uns_nsm}
}
\description{
Get a partially evaluated function
to simulate a true alignment with an unlinked node substitution site model.
}
\examples{
f <- get_sim_tral_with_uns_nsm_fun()
check_sim_tral_fun(f)
phylogeny <- ape::read.tree(text = "((A:1, B:1):1, C:2);")
true_alignment <- f(
  true_phylogeny = phylogeny,
  root_sequence = "acgt"
)
}
\seealso{
Use \link{get_sim_tral_with_lns_nsm_fun}
to get a partially evaluated function
to simulate a true alignment with a linked node substitution site model.
}
