% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm_pir_param_files.R
\name{rm_pir_param_files}
\alias{rm_pir_param_files}
\title{Deletes all files}
\usage{
rm_pir_param_files(pir_params)
}
\arguments{
\item{pir_params}{the parameters of \link[pirouette]{pirouette}.
They are created by \link{create_pir_params}.}
}
\value{
Nothing
}
\description{
Deletes all files
}
\examples{
if (beautier::is_on_ci()) {

  pir_params <- create_test_pir_params(
    experiments = list(create_test_gen_experiment())
  )

  filenames <- get_pir_params_filenames(pir_params)

  if (beautier::is_on_ci() && is_beast2_installed()) {

    # Minimal pirouette run
    errors <- pir_run(
      phylogeny = ape::read.tree(text = "((A:2, B:2):1, C:3);"),
      pir_params = pir_params
    )
    # Removing the files
    rm_pir_param_files(pir_params)
  }
}
}
\author{
Richèl J.C. Bilderbeek
}
