% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pir_plot.R
\name{pir_plot}
\alias{pir_plot}
\title{Plot the error 'BEAST2' makes from a known phylogeny}
\usage{
pir_plot(pir_out, verbose = FALSE)
}
\arguments{
\item{pir_out}{the output of \link{pir_run}}

\item{verbose}{if TRUE, show more output}
}
\value{
a \code{ggplot2} plot
}
\description{
Plot the error 'BEAST2' makes from a known phylogeny
}
\examples{
pir_out <- create_test_pir_run_output(
  add_twin = TRUE,
  add_best = TRUE
)
pir_plot(pir_out)
}
\seealso{
\itemize{
  \item Use \link{create_test_pir_run_output} to create a test output
    of \link{pir_run}.
  \item Use \link{pir_plot_from_file} to plot the errors after have
    being saved to a \code{.csv} file
  \item Use \link{pir_plots} to plot the output of multiple runs,
    for example, the output of \link{pir_runs}
}
}
\author{
Richèl J.C. Bilderbeek, Giovanni Laudanno
}
