% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot.R
\name{pivot}
\alias{pivot}
\title{Pivot a table}
\usage{
pivot(data, key, value, ..., fill = NULL)
}
\arguments{
\item{data}{A data frame.}

\item{key}{Column names or positions. This is passed to
\code{\link[tidyselect:vars_pull]{tidyselect::vars_pull()}}.

These arguments are passed by expression and support
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names or column positions).}

\item{value}{Column names or positions. This is passed to
\code{\link[tidyselect:vars_pull]{tidyselect::vars_pull()}}.

These arguments are passed by expression and support
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names or column positions).}

\item{...}{Selection criteria for levels of key to select.}

\item{fill}{If set, missing values will be replaced with this value. Note
that there are two types of missingness in the input: explicit missing
values (i.e. \code{NA}), and implicit missings, rows that simply aren't
present. Both types of missing value will be replaced by \code{fill}.}
}
\description{
Pivot a table
}
\examples{
library(dplyr)
library(dbplyr)
# establish db as a database connection
\dontshow{
   con <- simulate_mssql()
   src <- src_dbi(con)
   base <- list( x = ident('##iris')
               , vars  = tbl_vars(iris)
               ) \%>\% structure(class=c('op_base_remote', 'op_base', 'op'))
   db_iris <- structure( list( src = src
                             , ops = base
                             )
       , class = c('tbl_dbi', 'tbl_sql', 'tbl_lazy', 'tbl'))
}
\dontrun{
db_iris <- copy_to(db, iris)
}
result <- pivot( db_iris, Species, mean(Petal.Length, na.rm=TRUE)
               , setosa, versicolor, virginica)
sql_render(result)

}
