% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PivotData.R
\docType{class}
\name{PivotData}
\alias{PivotData}
\title{A class that contains named data frames.}
\format{\code{\link{R6Class}} object.}
\usage{
PivotData
}
\value{
Object of \code{\link{R6Class}} with properties and methods that help
  quickly storing and retrieving data frames.
}
\description{
The PivotData class stores all of the data frames associated with a pivot
table.
}
\section{Fields}{

\describe{
\item{\code{parentPivot}}{Owning pivot table.}
}}

\section{Methods}{

\describe{
  \item{Documentation}{For more complete explanations and examples please see
  the extensive vignettes supplied with this package.}
  \item{\code{new(...)}}{Create a new pivot data container, specifying the
  field value documented above.}

  \item{\code{addData(df, dataName)}}{And a data frame to the pivot table,
  specifying a name that can be used to easily retrieve it or refer to it
  later.}
  \item{\code{getData(dataName)}}{Get the data frame with the specified
  name.}
  \item{\code{isKnownData(dataName))}}{Check if a data frame exists with the
  specified name.}
  \item{\code{asList()}}{Get a list representation of the contained data
  frames.}
  \item{\code{asJSON()}}{Get a JSON representation of the contained data
  frames.}
}
}

\examples{
# This class should only be created by the pivot table.
# It is not intended to be created outside of the pivot table.
}
\keyword{datasets}
