% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicTable.R
\name{renderBasicTable}
\alias{renderBasicTable}
\title{Output a table into a package vignette.}
\usage{
renderBasicTable(
  matrix = NULL,
  stylePrefix = NULL,
  columnNamesAsHeader = FALSE,
  rowNamesAsHeader = FALSE,
  columnAlignment = "right"
)
}
\arguments{
\item{matrix}{Tabular data to render.}

\item{stylePrefix}{Text prefix for CSS style declarations.}

\item{columnNamesAsHeader}{Include column names in output (if FALSE, the
first row from the matrix is used as the column headings).}

\item{rowNamesAsHeader}{Include row names in output.}

\item{columnAlignment}{A character vector specifying the horizontal alignment
of each column.}
}
\value{
A basic table rendered as a HTML widget.
}
\description{
\code{renderBasicTable} is utility function that renders a basic table into a
package vignette.  This function is primarily intended for internal use by
the pivottabler package.
}
\examples{
renderBasicTable(matrix(c(1:12), nrow=3))
}
