% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PivotTable.R
\docType{class}
\name{PivotTable}
\alias{PivotTable}
\title{R6 class that represents a pivot table.}
\format{
\code{\link{R6Class}} object.
}
\description{
The `PivotTable` class is the primary class for
constructing and interacting with a pivot table.
}
\examples{
# The package vignettes include extensive examples of working with the
# PivotTable class.
library(pivottabler)
pt <- PivotTable$new()
pt$addData(bhmtrains)
pt$addColumnDataGroups("TrainCategory")
pt$addRowDataGroups("TOC")
pt$defineCalculation(calculationName="TotalTrains",
summariseExpression="n()")
pt$renderPivot()
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{argumentCheckMode}}{The level of argument checking to perform.
One of "auto", "none", "minimal", "basic", "balanced" (default)
or "full".}

\item{\code{compatibility}}{A list containing compatibility options to force
legacy behaviours.  See the NEWS file for details.}

\item{\code{traceEnabled}}{Default `FALSE`.  Specify `TRUE` to generate a trace
for debugging purposes.}

\item{\code{processingLibrary}}{The package to use when processing data.
Must be one of "auto" (which today is dplyr), "dplyr" or "data.table".}

\item{\code{data}}{A `PivotData` object containing the data frames added to the
pivot table.}

\item{\code{rowGroup}}{The hidden root `PivotDataGroup` at the top of the row
data groups hierarchy.  The children of this group form the first level
of visible row data groups.}

\item{\code{columnGroup}}{The hidden root `PivotDataGroup` at the top of the
column data groups hierarchy.  The children of this group form the first
level of visible column data groups.}

\item{\code{rowGroupLevelCount}}{The number of visible levels in the row data
group hierarchy.}

\item{\code{columnGroupLevelCount}}{The number of visible levels in the column
data group hierarchy.}

\item{\code{topColumnGroups}}{A list containing the first level of column data
groups.}

\item{\code{leafColumnGroups}}{A list containing the bottom level of column
data groups.}

\item{\code{allColumnGroups}}{A list containing all of the column data groups.}

\item{\code{topRowGroups}}{A list containing the first level of row data
groups.}

\item{\code{leafRowGroups}}{A list containing the bottom level of row data
groups.}

\item{\code{allRowGroups}}{A list containing all of the row data groups.}

\item{\code{rowGrpHeaders}}{A list containing the row group headers.}

\item{\code{calculationGroups}}{A list containing the calculation groups in
the pivot table.}

\item{\code{calculationsPosition}}{Either "row" or "column" describing which axis
the calculations are rendered.}

\item{\code{evaluationMode}}{Either "batch" (default) or "sequential" (legacy).}

\item{\code{batchInfo}}{Diagnostic information describing the batches used in the
last pivot table evaluation.}

\item{\code{cells}}{A `PivotCells` object that contains all of the cells in the pivot
table.}

\item{\code{allCells}}{A list of all of the cells in the pivot table, where each element
in the list is a 'PivotCell' object.}

\item{\code{rowCount}}{The number of rows in the pivot table, excluding headings.}

\item{\code{columnCount}}{The number of columns in the pivot table, excluding headings.}

\item{\code{fixedWidthSized}}{The total width of the pivot table in characters if
the pivot table were to be rendered as plain text, e.g. to the console.}

\item{\code{asCharacter}}{A plain text representation of the pivot table.}

\item{\code{theme}}{The name of the theme used to style the pivot table.
If setting this property, either a theme name can be used, or
a list can be used (which specifies a simple theme) or a
`PivotStyles` object can be used.
See the "Styling" vignette for details and examples.}

\item{\code{styles}}{A `PivotStyles` object that contains the styles
applied to the pivot table.}

\item{\code{allowExternalStyles}}{Default `FALSE`, which means the `PivotStyles`
object checks that style names specified for styling the different
parts of the pivot table must exist in the styles collection.  If they do
not an error will occur.  Specify `TRUE` to disable this check, e.g. if
the style definitions are not managed by `pivottabler` but instead
in an external system.}

\item{\code{mergeEmptyRowSpace}}{A character value describing how empty
space is merged.  Allowed values:  "doNotMerge", "dataGroupsOnly",
"cellsOnly", "dataGroupsAndCellsAs1", "dataGroupsAndCellsAs2".}

\item{\code{mergeEmptyColumnSpace}}{A character value describing how empty
space is merged.  Allowed values:  "doNotMerge", "dataGroupsOnly",
"cellsOnly", "dataGroupsAndCellsAs1", "dataGroupsAndCellsAs2".}

\item{\code{mergeEmptySpaceDirection}}{A character value describing how empty
space is merged.  Allowed values:  "row" or "column"}

\item{\code{allTimings}}{Get a data frame containing timing details
of pivot table operations.}

\item{\code{significantTimings}}{Get a data frame containing timing details
of significant pivot table operations (i.e. where elapsed>0.1).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PivotTable-new}{\code{PivotTable$new()}}
\item \href{#method-PivotTable-setDefault}{\code{PivotTable$setDefault()}}
\item \href{#method-PivotTable-getDefault1}{\code{PivotTable$getDefault1()}}
\item \href{#method-PivotTable-getDefault2}{\code{PivotTable$getDefault2()}}
\item \href{#method-PivotTable-getDefault3}{\code{PivotTable$getDefault3()}}
\item \href{#method-PivotTable-getNextInstanceId}{\code{PivotTable$getNextInstanceId()}}
\item \href{#method-PivotTable-addData}{\code{PivotTable$addData()}}
\item \href{#method-PivotTable-addTotalData}{\code{PivotTable$addTotalData()}}
\item \href{#method-PivotTable-getColumnGroupsByLevel}{\code{PivotTable$getColumnGroupsByLevel()}}
\item \href{#method-PivotTable-getTopColumnGroups}{\code{PivotTable$getTopColumnGroups()}}
\item \href{#method-PivotTable-getLeafColumnGroups}{\code{PivotTable$getLeafColumnGroups()}}
\item \href{#method-PivotTable-getLeafColumnGroup}{\code{PivotTable$getLeafColumnGroup()}}
\item \href{#method-PivotTable-addColumnGroup}{\code{PivotTable$addColumnGroup()}}
\item \href{#method-PivotTable-addColumnDataGroups}{\code{PivotTable$addColumnDataGroups()}}
\item \href{#method-PivotTable-normaliseColumnGroups}{\code{PivotTable$normaliseColumnGroups()}}
\item \href{#method-PivotTable-sortColumnDataGroups}{\code{PivotTable$sortColumnDataGroups()}}
\item \href{#method-PivotTable-getRowGroupsByLevel}{\code{PivotTable$getRowGroupsByLevel()}}
\item \href{#method-PivotTable-getTopRowGroups}{\code{PivotTable$getTopRowGroups()}}
\item \href{#method-PivotTable-getLeafRowGroups}{\code{PivotTable$getLeafRowGroups()}}
\item \href{#method-PivotTable-getLeafRowGroup}{\code{PivotTable$getLeafRowGroup()}}
\item \href{#method-PivotTable-addRowGroup}{\code{PivotTable$addRowGroup()}}
\item \href{#method-PivotTable-addRowDataGroups}{\code{PivotTable$addRowDataGroups()}}
\item \href{#method-PivotTable-normaliseRowGroups}{\code{PivotTable$normaliseRowGroups()}}
\item \href{#method-PivotTable-sortRowDataGroups}{\code{PivotTable$sortRowDataGroups()}}
\item \href{#method-PivotTable-setRowDataGroupHeader}{\code{PivotTable$setRowDataGroupHeader()}}
\item \href{#method-PivotTable-addCalculationGroup}{\code{PivotTable$addCalculationGroup()}}
\item \href{#method-PivotTable-defineCalculation}{\code{PivotTable$defineCalculation()}}
\item \href{#method-PivotTable-addColumnCalculationGroups}{\code{PivotTable$addColumnCalculationGroups()}}
\item \href{#method-PivotTable-addRowCalculationGroups}{\code{PivotTable$addRowCalculationGroups()}}
\item \href{#method-PivotTable-addStyle}{\code{PivotTable$addStyle()}}
\item \href{#method-PivotTable-createInlineStyle}{\code{PivotTable$createInlineStyle()}}
\item \href{#method-PivotTable-setStyling}{\code{PivotTable$setStyling()}}
\item \href{#method-PivotTable-mapStyling}{\code{PivotTable$mapStyling()}}
\item \href{#method-PivotTable-generateCellStructure}{\code{PivotTable$generateCellStructure()}}
\item \href{#method-PivotTable-resetCells}{\code{PivotTable$resetCells()}}
\item \href{#method-PivotTable-evaluateCells}{\code{PivotTable$evaluateCells()}}
\item \href{#method-PivotTable-evaluatePivot}{\code{PivotTable$evaluatePivot()}}
\item \href{#method-PivotTable-findRowDataGroups}{\code{PivotTable$findRowDataGroups()}}
\item \href{#method-PivotTable-findColumnDataGroups}{\code{PivotTable$findColumnDataGroups()}}
\item \href{#method-PivotTable-getEmptyRows}{\code{PivotTable$getEmptyRows()}}
\item \href{#method-PivotTable-getEmptyColumns}{\code{PivotTable$getEmptyColumns()}}
\item \href{#method-PivotTable-getCell}{\code{PivotTable$getCell()}}
\item \href{#method-PivotTable-getCells}{\code{PivotTable$getCells()}}
\item \href{#method-PivotTable-findCells}{\code{PivotTable$findCells()}}
\item \href{#method-PivotTable-findGroupColumnNumbers}{\code{PivotTable$findGroupColumnNumbers()}}
\item \href{#method-PivotTable-findGroupRowNumbers}{\code{PivotTable$findGroupRowNumbers()}}
\item \href{#method-PivotTable-removeColumn}{\code{PivotTable$removeColumn()}}
\item \href{#method-PivotTable-removeColumns}{\code{PivotTable$removeColumns()}}
\item \href{#method-PivotTable-removeEmptyColumns}{\code{PivotTable$removeEmptyColumns()}}
\item \href{#method-PivotTable-removeRow}{\code{PivotTable$removeRow()}}
\item \href{#method-PivotTable-removeRows}{\code{PivotTable$removeRows()}}
\item \href{#method-PivotTable-removeEmptyRows}{\code{PivotTable$removeEmptyRows()}}
\item \href{#method-PivotTable-print}{\code{PivotTable$print()}}
\item \href{#method-PivotTable-asMatrix}{\code{PivotTable$asMatrix()}}
\item \href{#method-PivotTable-asDataMatrix}{\code{PivotTable$asDataMatrix()}}
\item \href{#method-PivotTable-asDataFrame}{\code{PivotTable$asDataFrame()}}
\item \href{#method-PivotTable-asTidyDataFrame}{\code{PivotTable$asTidyDataFrame()}}
\item \href{#method-PivotTable-getMerges}{\code{PivotTable$getMerges()}}
\item \href{#method-PivotTable-asBasicTable}{\code{PivotTable$asBasicTable()}}
\item \href{#method-PivotTable-getCss}{\code{PivotTable$getCss()}}
\item \href{#method-PivotTable-getHtml}{\code{PivotTable$getHtml()}}
\item \href{#method-PivotTable-saveHtml}{\code{PivotTable$saveHtml()}}
\item \href{#method-PivotTable-renderPivot}{\code{PivotTable$renderPivot()}}
\item \href{#method-PivotTable-getLatex}{\code{PivotTable$getLatex()}}
\item \href{#method-PivotTable-writeToExcelWorksheet}{\code{PivotTable$writeToExcelWorksheet()}}
\item \href{#method-PivotTable-trace}{\code{PivotTable$trace()}}
\item \href{#method-PivotTable-showBatchInfo}{\code{PivotTable$showBatchInfo()}}
\item \href{#method-PivotTable-asList}{\code{PivotTable$asList()}}
\item \href{#method-PivotTable-asJSON}{\code{PivotTable$asJSON()}}
\item \href{#method-PivotTable-viewJSON}{\code{PivotTable$viewJSON()}}
\item \href{#method-PivotTable-finalize}{\code{PivotTable$finalize()}}
\item \href{#method-PivotTable-clone}{\code{PivotTable$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-new"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-new}{}}}
\subsection{Method \code{new()}}{
Create a new `PivotTable` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$new(
  processingLibrary = "auto",
  evaluationMode = "batch",
  argumentCheckMode = "auto",
  theme = NULL,
  replaceExistingStyles = FALSE,
  tableStyle = NULL,
  headingStyle = NULL,
  cellStyle = NULL,
  totalStyle = NULL,
  compatibility = NULL,
  traceEnabled = FALSE,
  traceFile = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{processingLibrary}}{The package to use when processing data.
Must be one of "auto" (which today is dplyr), "dplyr" or "data.table".}

\item{\code{evaluationMode}}{Either "batch" (default) or "sequential" (legacy).}

\item{\code{argumentCheckMode}}{The level of argument checking to perform.
Must be one of "auto", "none", "minimal", "basic", "balanced" (default)
or "full".}

\item{\code{theme}}{A theme to use to style the pivot table. Either:\cr
(1) The name of a built in theme, or\cr
(2) A list of simple style settings, or\cr
(3) A `PivotStyles` object containing a full set of styles.\cr
See the "Styling" vignette for many examples.}

\item{\code{replaceExistingStyles}}{Default `FALSE` to retain existing styles in
the styles collection and add specified styles as new custom styles.
Specify `TRUE` to update the definitions of existing styles.}

\item{\code{tableStyle}}{Styling to apply to the table.  Either:\cr
(1) The name of a built in style, or\cr
(2) A list of CSS style declarations, e.g.\cr
`list("font-weight"="bold", "color"="#0000FF")`, or\cr
(3) A `PivotStyle` object.}

\item{\code{headingStyle}}{Styling to apply to the headings.
See the `tableStyle` argument for details.}

\item{\code{cellStyle}}{Styling to apply to the normal cells.
See the `tableStyle` argument for details.}

\item{\code{totalStyle}}{Styling to apply to the total cells.
See the `tableStyle` argument for details.}

\item{\code{compatibility}}{A list containing compatibility options to force
legacy behaviours.  See the NEWS file for details.}

\item{\code{traceEnabled}}{Default `FALSE`.  Specify `TRUE` to generate a trace
for debugging purposes.}

\item{\code{traceFile}}{If tracing is enabled, the location to generate the trace file.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `PivotTable` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-setDefault"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-setDefault}{}}}
\subsection{Method \code{setDefault()}}{
Specify default values for some function arguments.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$setDefault(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Default values to specify.  See details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Defaults can be set for the following arguments of
`pt$addRowDataGroups()` and `pt$addColumnDataGroups()`:
`logical` values: `addTotal`, `expandExistingTotals`, `visualTotals`.
`character` values:  `totalPosition`, `totalCaption`.
`list` or `logical` values:  `outlineBefore`, `outlineAfter`, `outlineTotal`.\cr
Errors are generated for default values that could not be set.\cr
Warnings are generated for attempts to set defaults that aren't supported.\cr
See the "A1. Appendix" vignette for more details.
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getDefault1"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getDefault1}{}}}
\subsection{Method \code{getDefault1()}}{
Get the default value of an argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getDefault1(argValue = NULL, useDefault = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{argValue}}{The name and value of the argument.}

\item{\code{useDefault}}{Specify `TRUE` to use the default.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Both the argument name and argument value are taken from the `argValue`
argument.  The name is obtained from `as.character(substitute(argValue))`.
This function is designed to easily slot into existing code, e.g.
`getDefault1(addTotal, missing(addTotal))`.
}

\subsection{Returns}{
The current value of the argument or the default value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getDefault2"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getDefault2}{}}}
\subsection{Method \code{getDefault2()}}{
Get the default value of an argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getDefault2(argName = NULL, argValue = NULL, useDefault = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{argName}}{The name of the argument.}

\item{\code{argValue}}{The current value of the argument.}

\item{\code{useDefault}}{Specify `TRUE` to use the default.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The current value of the argument or the default value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getDefault3"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getDefault3}{}}}
\subsection{Method \code{getDefault3()}}{
Get the default value of an argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getDefault3(argName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{argName}}{The name of the argument.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The default value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getNextInstanceId"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getNextInstanceId}{}}}
\subsection{Method \code{getNextInstanceId()}}{
Get the next unique object instance identifier.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getNextInstanceId()}\if{html}{\out{</div>}}
}

\subsection{Details}{
R6 classes cannot be easily compared to check if two variables are both
referring to the same object instance.  Instance ids are a mechanism to
work around this problem.  Each data group and cell is assigned an
instance id during object creation, which enables reliable reference
comparisons.
}

\subsection{Returns}{
An integer instance id.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-addData"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-addData}{}}}
\subsection{Method \code{addData()}}{
Add a data frame with the specified name to the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$addData(dataFrame = NULL, dataName = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataFrame}}{The data frame to add.}

\item{\code{dataName}}{The name to be used to refer to the data frame.
If no name is specified, the data frame variable name from the
calling code is used, retrieved via `deparse(substitute(dataFrame))`.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The name is used to refer to the data frame when generating data groups
or defining calculations.  The pivot table tracks the first data frame
added as the default data frame, so if only a single data frame is used,
it is typically not necessary to ever explicitly refer to the name.
Pivot tables are typically based on a single data frame, however it
is possible to build a pivot table that uses data from multiple data
frames.
}

\subsection{Returns}{
The `PivotData` object managing the data frames for the pivot table.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-addTotalData"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-addTotalData}{}}}
\subsection{Method \code{addTotalData()}}{
Add a data frame containing totals data with the specified name and
variables to the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$addTotalData(
  dataFrame = NULL,
  dataName = NULL,
  variableNames = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataFrame}}{The data frame to add.}

\item{\code{dataName}}{The name of the data frame to associate these totals with.}

\item{\code{variableNames}}{A vector specifying how the aggregate data/totals in
the data frame are grouped.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
When generating pivot tables, the package typically calculates cell values.
However, the package can also use provided values (i.e. carry out no
calculations).  This presents a challenge in that the sub-totals and totals
in a pivot table display values at a higher aggregation level than the
normal cells in the body of the pivot table.  This method allows further
data frames to be specified that contain aggregated versions of the data.
See the "Calculations" vignette for details and an example.
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getColumnGroupsByLevel"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getColumnGroupsByLevel}{}}}
\subsection{Method \code{getColumnGroupsByLevel()}}{
Retrieve the data groups at the specified level or levels in the column
groups hierarchy.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getColumnGroupsByLevel(level = NULL, collapse = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{level}}{An integer value or vector specifying one or more level numbers.
Level 1 represents the first visible level of data groups.}

\item{\code{collapse}}{A logical value specifying whether the return value should be
simplified.  See details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If `level` is a vector:  If `collapse` is `FALSE`, then a list of lists is
returned, if `collapse` is `TRUE`, then a single combined list is returned.
}

\subsection{Returns}{
A list containing `PivotDataGroup` objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getTopColumnGroups"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getTopColumnGroups}{}}}
\subsection{Method \code{getTopColumnGroups()}}{
[Deprecated: Use topColumnGroups instead]
Retrieve the first level of column data groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getTopColumnGroups()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list containing `PivotDataGroup` objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getLeafColumnGroups"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getLeafColumnGroups}{}}}
\subsection{Method \code{getLeafColumnGroups()}}{
[Deprecated: Use leafColumnGroups instead]
Retrieve the bottom level of column data groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getLeafColumnGroups()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list containing `PivotDataGroup` objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getLeafColumnGroup"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getLeafColumnGroup}{}}}
\subsection{Method \code{getLeafColumnGroup()}}{
Retrieve the leaf-level data group associated with a specific column or
columns.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getLeafColumnGroup(c = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{c}}{An integer column number or an integer vector of column numbers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A `PivotDataGroup` object or a list of `PivotDataGroup` objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-addColumnGroup"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-addColumnGroup}{}}}
\subsection{Method \code{addColumnGroup()}}{
Add a new column data group at the top level of the column group
hierarchy.  The new group is added as the last child unless an index
is specified.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$addColumnGroup(
  variableName = NULL,
  filterType = "ALL",
  values = NULL,
  doNotExpand = FALSE,
  isEmpty = FALSE,
  isOutline = FALSE,
  styleAsOutline = FALSE,
  captionTemplate = "{value}",
  caption = NULL,
  isTotal = FALSE,
  isLevelSubTotal = FALSE,
  isLevelTotal = FALSE,
  calculationGroupName = NULL,
  calculationName = NULL,
  baseStyleName = NULL,
  styleDeclarations = NULL,
  insertAtIndex = NULL,
  insertBeforeGroup = NULL,
  insertAfterGroup = NULL,
  mergeEmptySpace = NULL,
  cellBaseStyleName = NULL,
  cellStyleDeclarations = NULL,
  sortAnchor = NULL,
  resetCells = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{variableName}}{A character value that specifies the name of the
variable in the data frame that the group relates to and will filter.}

\item{\code{filterType}}{Must be one of "ALL", "VALUES", or "NONE" to specify
the filter type:\cr
ALL means no filtering is applied.\cr
VALUEs is the typical value used to specify that `variableName` is
filtered to only `values`.\cr
NONE means no data will match this data group.}

\item{\code{values}}{A vector that specifies the filter values applied to
`variableName` to select the data to match this row/column in the pivot
table.}

\item{\code{doNotExpand}}{Default value `FALSE` - specify `TRUE` to
prevent the high-level methods such as `addDataGroups()` from adding
child groups.}

\item{\code{isEmpty}}{Default value `FALSE`, specify `TRUE` to mark that
this group contains no data (e.g. if
it is part of a header or outline row)}

\item{\code{isOutline}}{Default value `FALSE` - specify `TRUE` to mark
that this data group is an outline group.}

\item{\code{styleAsOutline}}{Default value `FALSE` - specify `TRUE` to style
this data group as an outline group.  Only applicable when
`isOutline` is `TRUE`.}

\item{\code{captionTemplate}}{A character value that specifies the template
for the data group caption, default "{values}".}

\item{\code{caption}}{Effectively a hard-coded caption that overrides the
built-in logic for generating a caption.}

\item{\code{isTotal}}{Default `FALSE` - specify `TRUE` to mark that this
data group is a total.}

\item{\code{isLevelSubTotal}}{Default `FALSE` - specify `TRUE` to mark that
this data group is a sub-total within a level.}

\item{\code{isLevelTotal}}{Default `FALSE` - specify `TRUE` to mark that
this data group is level total.}

\item{\code{calculationGroupName}}{For calculation groups, this character value
specifies the calculation group that `calculationName` belongs to.}

\item{\code{calculationName}}{For calculation groups, this character value
specifies the name of the calculation.}

\item{\code{baseStyleName}}{The style name for the data group.}

\item{\code{styleDeclarations}}{A list of CSS style declarations to overlay
on top of the base style.}

\item{\code{insertAtIndex}}{An integer that specifies the index in the list
of child groups where the new group should be inserted.}

\item{\code{insertBeforeGroup}}{Specifies an existing group that the new group
should be inserted before.}

\item{\code{insertAfterGroup}}{Specifies an existing group that the new group
should be inserted after}

\item{\code{mergeEmptySpace}}{A character value that specifies how empty space
should be merged. This is typically only used with outline groups
(so applies to row groups only, not column groups).  Must be one of
"doNotMerge", "dataGroupsOnly", "cellsOnly", "dataGroupsAndCellsAs1" or
"dataGroupsAndCellsAs2".  See the "Regular Layout" vignette
for more information.}

\item{\code{cellBaseStyleName}}{The style name for cells related to this data
group.}

\item{\code{cellStyleDeclarations}}{A list of CSS style declarations to overlay
on top of the base style for cells related to this data group}

\item{\code{sortAnchor}}{Used to specify sort behaviour for outline groups, must
be one of "fixed", "next" or "previous".}

\item{\code{resetCells}}{Default `TRUE` to reset any cells that currently exist
in the pivot table and trigger a recalculation of the pivot table when
it is next rendered.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See the "Irregular Layout" vignette for details and examples.
}

\subsection{Returns}{
The new `PivotDataGroup` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-addColumnDataGroups"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-addColumnDataGroups}{}}}
\subsection{Method \code{addColumnDataGroups()}}{
Add multiple new data groups to the column group hierarchy
based on the distinct values in a data frame
column or using explicitly specified data values.
See the "Data Groups" vignette for example usage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$addColumnDataGroups(
  variableName = NULL,
  atLevel = NULL,
  fromData = TRUE,
  dataName = NULL,
  dataSortOrder = "asc",
  customSortOrder = NULL,
  caption = "{value}",
  dataFormat = NULL,
  dataFmtFuncArgs = NULL,
  onlyCombinationsThatExist = TRUE,
  explicitListOfValues = NULL,
  calculationGroupName = NULL,
  expandExistingTotals = FALSE,
  addTotal = TRUE,
  visualTotals = FALSE,
  totalPosition = "after",
  totalCaption = "Total",
  onlyAddGroupIf = NULL,
  preGroupData = TRUE,
  baseStyleName = NULL,
  styleDeclarations = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{variableName}}{The name of the related column in the data frame(s) of
the pivot table.}

\item{\code{atLevel}}{The level number that specifies where to add the new
groups.  Level 1 = on the first visible level of the hierarchy.
`NULL` = create a new level at the bottom of the hierarchy for the new
groups.}

\item{\code{fromData}}{Default `TRUE` to generate the new data groups based on the
data values that exist in the `variableName` column in the named data frame.
If `FALSE`, then `explicitListOfValues` must be specified.}

\item{\code{dataName}}{The name of the data frame (as specified in
`pt$addData()`) to read the data group values from.}

\item{\code{dataSortOrder}}{Must be one of "asc", "desc", "custom" or "none".}

\item{\code{customSortOrder}}{A vector values sorted into the desired order.}

\item{\code{caption}}{The template of data group captions to generate,
default "{value}".}

\item{\code{dataFormat}}{A character, list or custom function to format the
data value.}

\item{\code{dataFmtFuncArgs}}{A list that specifies any additional arguments to
pass to a custom format function.}

\item{\code{onlyCombinationsThatExist}}{Default `TRUE` to generate only
combinations of data groups that exist in the data frame.}

\item{\code{explicitListOfValues}}{A list of explicit values to create data
groups from.  A data group is created for each element of the list.
If a list element is vector of values (with length greater than 1),
then a data group is created for multiple values instead of just
a single value.}

\item{\code{calculationGroupName}}{The calculation group that the new data groups
are related to.}

\item{\code{expandExistingTotals}}{Default `FALSE`, which means totals are not
broken down in multi-level hierarchies.}

\item{\code{addTotal}}{Default `TRUE`, which means sub-total and total data groups
are automatically added.}

\item{\code{visualTotals}}{Default `FALSE`, which means visual totals are disabled.
See the "Data Groups" vignette for more details about visual totals.}

\item{\code{totalPosition}}{Either "before" or "after" to specify where total groups
are created, default "after".}

\item{\code{totalCaption}}{The caption to display on total groups, default "Total".}

\item{\code{onlyAddGroupIf}}{A filter expression that can be used to more finely
control whether data groups are created at different locations in the
hierarchy.  There must be at least one row that matches this filter and the
filters from the ancestor groups in order that the child group is created.
E.g. `MaxDisplayLevel>5`.}

\item{\code{preGroupData}}{Default `TRUE`, which means that the pivot table
pre-calculates the distinct combinations of variable values to reduce the CPU
time and elapsed time required to generate data groups.
Cannot be used in conjunction with the}

\item{\code{baseStyleName}}{The name of the style applied to this data group (i.e.
this row/column heading).  The style must exist in the `PivotStyles` object
associated with the PivotTable.}

\item{\code{styleDeclarations}}{CSS style declarations that can override the base
style, expressed as a list, e.g. `list("font-weight"=bold")`.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
There are broadly three different ways to call `addColumnDataGroups()`:\cr
(1) dataName=name, fromData=TRUE, onlyCombinationsThatExist=TRUE - which
considers the ancestors of each existing data group to generate only those
combinations of values that exist in the data frame.\cr
(2) dataName=name, fromData=TRUE, onlyCombinationsThatExist=FALSE - which
ignores the ancestors of each existing data group and simply adds every
distinct value of the specified variable under every existing data group,
which can result in combinations of values in the pivot table that don't
exist in the data frame (i.e. blank rows/columns in the pivot table).\cr
(3) fromData=FALSE, explicitListOfValues=list(...) - simply adds every
value from the specified list under every existing data group.
}

\subsection{Returns}{
A list of new `PivotDataGroup` objects that have been added.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-normaliseColumnGroups"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-normaliseColumnGroups}{}}}
\subsection{Method \code{normaliseColumnGroups()}}{
Normalise the column data group hierarchy so that all branches have the
same number of levels - accomplished by adding empty child data groups
where needed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$normaliseColumnGroups(resetCells = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resetCells}}{Default `TRUE` to reset any cells that currently exist
in the pivot table and trigger a recalculation of the pivot table when
it is next rendered.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of new `PivotDataGroup` objects that have been added.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-sortColumnDataGroups"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-sortColumnDataGroups}{}}}
\subsection{Method \code{sortColumnDataGroups()}}{
Sort column data groups either by the data group data value, caption,
a custom order or based on calculation result values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$sortColumnDataGroups(
  levelNumber = 1,
  orderBy = "calculation",
  customOrder = NULL,
  sortOrder = "desc",
  calculationGroupName = "default",
  calculationName = NULL,
  fromIndex = NULL,
  toIndex = NULL,
  resetCells = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{levelNumber}}{The level number to sort the data groups, e.g.
level 1 (default) sorts the data groups at level 1 of the hierarchy
(which is the first visible level of data groups).}

\item{\code{orderBy}}{Must be either "value", "caption", "calculation",
"customByValue" or "customByCaption".\cr
"value" sorts by the raw (i.e. unformatted) group value.\cr
"caption" sorts by the formatted character group caption.\cr
"calculation" sorts using one of the calculations defined in the pivot table.\cr
"customValue" sorts by the raw (i.e. unformatted) group value according to
the specified custom sort order.\cr
"customCaption" sorts by the formatted character group caption according to
the specified custom sort order.}

\item{\code{customOrder}}{A vector values sorted into the desired order.}

\item{\code{sortOrder}}{Must be either "asc" or "desc".}

\item{\code{calculationGroupName}}{If sorting using a calculation, the name of the
calculation group containing the specified calculation.}

\item{\code{calculationName}}{If sorting using a calculation, the name of the
calculation.}

\item{\code{fromIndex}}{A boundary to limit the sort operation.}

\item{\code{toIndex}}{A boundary to limit the sort operation.}

\item{\code{resetCells}}{Default `TRUE` to reset any cells that currently exist
in the pivot table and trigger a recalculation of the pivot table when
it is next rendered.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getRowGroupsByLevel"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getRowGroupsByLevel}{}}}
\subsection{Method \code{getRowGroupsByLevel()}}{
Retrieve the data groups at the specified level or levels in the row groups
hierarchy.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getRowGroupsByLevel(level = NULL, collapse = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{level}}{An integer value or vector specifying one or more level numbers.
Level 1 represents the first visible level of data groups.}

\item{\code{collapse}}{A logical value specifying whether the return value should be
simplified.  See details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If `level` is a vector:  If `collapse` is `FALSE`, then a list of lists is
returned, if `collapse` is `TRUE`, then a single combined list is returned.
}

\subsection{Returns}{
A list containing `PivotDataGroup` objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getTopRowGroups"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getTopRowGroups}{}}}
\subsection{Method \code{getTopRowGroups()}}{
[Deprecated: Use topRowGroups instead]
Retrieve the first level of row data groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getTopRowGroups()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list containing `PivotDataGroup` objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getLeafRowGroups"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getLeafRowGroups}{}}}
\subsection{Method \code{getLeafRowGroups()}}{
[Deprecated: Use leafRowGroups instead]
Retrieve the bottom level of row data groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getLeafRowGroups()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list containing `PivotDataGroup` objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getLeafRowGroup"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getLeafRowGroup}{}}}
\subsection{Method \code{getLeafRowGroup()}}{
Retrieve the leaf-level data group associated with a specific row or rows.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getLeafRowGroup(r = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{r}}{An integer row number or an integer vector of row numbers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A `PivotDataGroup` object or a list of `PivotDataGroup` objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-addRowGroup"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-addRowGroup}{}}}
\subsection{Method \code{addRowGroup()}}{
Add a new column data group at the top level of the row group
hierarchy.  The new group is added as the last child unless an index
is specified.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$addRowGroup(
  variableName = NULL,
  filterType = "ALL",
  values = NULL,
  doNotExpand = FALSE,
  isEmpty = FALSE,
  isOutline = FALSE,
  styleAsOutline = FALSE,
  captionTemplate = "{value}",
  caption = NULL,
  isTotal = FALSE,
  isLevelSubTotal = FALSE,
  isLevelTotal = FALSE,
  calculationGroupName = NULL,
  calculationName = NULL,
  baseStyleName = NULL,
  styleDeclarations = NULL,
  insertAtIndex = NULL,
  insertBeforeGroup = NULL,
  insertAfterGroup = NULL,
  mergeEmptySpace = NULL,
  cellBaseStyleName = NULL,
  cellStyleDeclarations = NULL,
  sortAnchor = NULL,
  resetCells = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{variableName}}{A character value that specifies the name of the
variable in the data frame that the group relates to and will filter.}

\item{\code{filterType}}{Must be one of "ALL", "VALUES", or "NONE" to specify
the filter type:\cr
ALL means no filtering is applied.\cr
VALUEs is the typical value used to specify that `variableName` is
filtered to only `values`.\cr
NONE means no data will match this data group.}

\item{\code{values}}{A vector that specifies the filter values applied to
`variableName` to select the data to match this row/column in the pivot
table.}

\item{\code{doNotExpand}}{Default value `FALSE` - specify `TRUE` to
prevent the high-level methods such as `addDataGroups()` from adding
child groups.}

\item{\code{isEmpty}}{Default value `FALSE`, specify `TRUE` to mark that
this group contains no data (e.g. if
it is part of a header or outline row)}

\item{\code{isOutline}}{Default value `FALSE` - specify `TRUE` to mark
that this data group is an outline group.}

\item{\code{styleAsOutline}}{Default value `FALSE` - specify `TRUE` to style
this data group as an outline group.  Only applicable when
`isOutline` is `TRUE`.}

\item{\code{captionTemplate}}{A character value that specifies the template
for the data group caption, default "{values}".}

\item{\code{caption}}{Effectively a hard-coded caption that overrides the
built-in logic for generating a caption.}

\item{\code{isTotal}}{Default `FALSE` - specify `TRUE` to mark that this
data group is a total.}

\item{\code{isLevelSubTotal}}{Default `FALSE` - specify `TRUE` to mark that
this data group is a sub-total within a level.}

\item{\code{isLevelTotal}}{Default `FALSE` - specify `TRUE` to mark that
this data group is level total.}

\item{\code{calculationGroupName}}{For calculation groups, this character value
specifies the calculation group that `calculationName` belongs to.}

\item{\code{calculationName}}{For calculation groups, this character value
specifies the name of the calculation.}

\item{\code{baseStyleName}}{The style name for the data group.}

\item{\code{styleDeclarations}}{A list of CSS style declarations to overlay
on top of the base style.}

\item{\code{insertAtIndex}}{An integer that specifies the index in the list
of child groups where the new group should be inserted.}

\item{\code{insertBeforeGroup}}{Specifies an existing group that the new group
should be inserted before.}

\item{\code{insertAfterGroup}}{Specifies an existing group that the new group
should be inserted after}

\item{\code{mergeEmptySpace}}{A character value that specifies how empty space
should be merged. This is typically only used with outline groups
(so applies to row groups only, not column groups).  Must be one of
"doNotMerge", "dataGroupsOnly", "cellsOnly", "dataGroupsAndCellsAs1" or
"dataGroupsAndCellsAs2".  See the "Regular Layout" vignette
for more information.}

\item{\code{cellBaseStyleName}}{The style name for cells related to this data
group.}

\item{\code{cellStyleDeclarations}}{A list of CSS style declarations to overlay
on top of the base style for cells related to this data group}

\item{\code{sortAnchor}}{Used to specify sort behaviour for outline groups, must
be one of "fixed", "next" or "previous".}

\item{\code{resetCells}}{Default `TRUE` to reset any cells that currently exist
in the pivot table and trigger a recalculation of the pivot table when
it is next rendered.}

\item{\code{outlineLinkedGroupId}}{Used to link an outline group to the value
data group which has the child data groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See the "Irregular Layout" vignette for details and examples.
}

\subsection{Returns}{
The new `PivotDataGroup` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-addRowDataGroups"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-addRowDataGroups}{}}}
\subsection{Method \code{addRowDataGroups()}}{
Add multiple new data groups to the row group hierarchy
based on the distinct values in a data frame
column or using explicitly specified data values.
See the "Data Groups" vignette for example usage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$addRowDataGroups(
  variableName = NULL,
  atLevel = NULL,
  fromData = TRUE,
  dataName = NULL,
  dataSortOrder = "asc",
  customSortOrder = NULL,
  caption = "{value}",
  dataFormat = NULL,
  dataFmtFuncArgs = NULL,
  onlyCombinationsThatExist = TRUE,
  explicitListOfValues = NULL,
  calculationGroupName = NULL,
  expandExistingTotals = FALSE,
  addTotal = TRUE,
  visualTotals = FALSE,
  totalPosition = "after",
  totalCaption = "Total",
  onlyAddGroupIf = NULL,
  preGroupData = TRUE,
  baseStyleName = NULL,
  styleDeclarations = NULL,
  header = NULL,
  outlineBefore = NULL,
  outlineAfter = NULL,
  outlineTotal = NULL,
  onlyAddOutlineChildGroupIf = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{variableName}}{The name of the related column in the data frame(s) of
the pivot table.}

\item{\code{atLevel}}{The level number that specifies where to add the new
groups.  Level 1 = on the first visible level of the hierarchy.
`NULL` = create a new level at the bottom of the hierarchy for the new
groups.}

\item{\code{fromData}}{Default `TRUE` to generate the new data groups based on the
data values that exist in the `variableName` column in the named data frame.
If `FALSE`, then `explicitListOfValues` must be specified.}

\item{\code{dataName}}{The name of the data frame (as specified in
`pt$addData()`) to read the data group values from.}

\item{\code{dataSortOrder}}{Must be one of "asc", "desc", "custom" or "none".}

\item{\code{customSortOrder}}{A vector values sorted into the desired order.}

\item{\code{caption}}{The template of data group captions to generate,
default "{value}".}

\item{\code{dataFormat}}{A character, list or custom function to format the
data value.}

\item{\code{dataFmtFuncArgs}}{A list that specifies any additional arguments to
pass to a custom format function.}

\item{\code{onlyCombinationsThatExist}}{Default `TRUE` to generate only
combinations of data groups that exist in the data frame.}

\item{\code{explicitListOfValues}}{A list of explicit values to create data
groups from.  A data group is created for each element of the list.
If a list element is vector of values (with length greater than 1),
then a data group is created for multiple values instead of just
a single value.}

\item{\code{calculationGroupName}}{The calculation group that the new data groups
are related to.}

\item{\code{expandExistingTotals}}{Default `FALSE`, which means totals are not
broken down in multi-level hierarchies.}

\item{\code{addTotal}}{Default `TRUE`, which means sub-total and total data groups
are automatically added.}

\item{\code{visualTotals}}{Default `FALSE`, which means visual totals are disabled.
See the "Data Groups" vignette for more details about visual totals.}

\item{\code{totalPosition}}{Either "before" or "after" to specify where total groups
are created, default "after".}

\item{\code{totalCaption}}{The caption to display on total groups, default "Total".}

\item{\code{onlyAddGroupIf}}{A filter expression that can be used to more finely
control whether data groups are created at different locations in the
hierarchy.  There must be at least one row that matches this filter and the
filters from the ancestor groups in order that the child group is created.
E.g. `MaxDisplayLevel>5`.}

\item{\code{preGroupData}}{Default `TRUE`, which means that the pivot table
pre-calculates the distinct combinations of variable values to reduce the CPU
time and elapsed time required to generate data groups.
Cannot be used in conjunction with the}

\item{\code{baseStyleName}}{The name of the style applied to this data group (i.e.
this row/column heading).  The style must exist in the `PivotStyles` object
associated with the PivotTable.}

\item{\code{styleDeclarations}}{CSS style declarations that can override the base
style, expressed as a list, e.g. `list("font-weight"=bold")`.}

\item{\code{header}}{A character value used as the row-group column caption
when row group headers are rendered.}

\item{\code{outlineBefore}}{Default `FALSE` to disable the creation of outline header
groups.  Specify either `TRUE` or a list of outline group settings to create
outline header groups.  See the "Regular Layout" vignette for details.}

\item{\code{outlineAfter}}{Default `FALSE` to disable the creation of outline footer
groups.  Specify either `TRUE` or a list of outline group settings to create
outline footer groups.  See the "Regular Layout" vignette for details.}

\item{\code{outlineTotal}}{Default `FALSE` to disable the creation of outline
totals.  Specify either `TRUE` or a list of outline group settings to create
outline totals.  See the "Regular Layout" vignette for details.}

\item{\code{onlyAddOutlineChildGroupIf}}{A filter expression that can be used to
more finely control whether outline child groups are created at different
locations in the hierarchy.  There must be at least one row that matches
this filter and the filters from the ancestor groups in order that the
outline child group is created.  E.g. `MaxDisplayLevel>5`.
See the "Regular Layout" vignette for an example.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
There are broadly three different ways to call `addRowDataGroups()`:\cr
(1) dataName=name, fromData=TRUE, onlyCombinationsThatExist=TRUE - which
considers the ancestors of each existing data group to generate only those
combinations of values that exist in the data frame.\cr
(2) dataName=name, fromData=TRUE, onlyCombinationsThatExist=FALSE - which
ignores the ancestors of each existing data group and simply adds every
distinct value of the specified variable under every existing data group,
which can result in combinations of values in the pivot table that don't
exist in the data frame (i.e. blank rows/columns in the pivot table).\cr
(3) fromData=FALSE, explicitListOfValues=list(...) - simply adds every
value from the specified list under every existing data group.
}

\subsection{Returns}{
A list of new `PivotDataGroup` objects that have been added.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-normaliseRowGroups"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-normaliseRowGroups}{}}}
\subsection{Method \code{normaliseRowGroups()}}{
Normalise the row data group hierarchy so that all branches have the
same number of levels - accomplished by adding empty child data groups
where needed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$normaliseRowGroups(resetCells = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resetCells}}{Default `TRUE` to reset any cells that currently exist
in the pivot table and trigger a recalculation of the pivot table when
it is next rendered.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of new `PivotDataGroup` objects that have been added.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-sortRowDataGroups"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-sortRowDataGroups}{}}}
\subsection{Method \code{sortRowDataGroups()}}{
Sort row data groups either by the data group data value, caption,
a custom order or based on calculation result values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$sortRowDataGroups(
  levelNumber = 1,
  orderBy = "calculation",
  customOrder = NULL,
  sortOrder = "desc",
  calculationGroupName = "default",
  calculationName = NULL,
  fromIndex = NULL,
  toIndex = NULL,
  resetCells = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{levelNumber}}{The level number to sort the data groups, e.g.
level 1 (default) sorts the data groups at level 1 of the hierarchy
(which is the first visible level of data groups).}

\item{\code{orderBy}}{Must be either "value", "caption", "calculation",
"customByValue" or "customByCaption".\cr
"value" sorts by the raw (i.e. unformatted) group value.\cr
"caption" sorts by the formatted character group caption.\cr
"calculation" sorts using one of the calculations defined in the pivot table.
"customValue" sorts by the raw (i.e. unformatted) group value according to
the specified custom sort order.\cr
"customCaption" sorts by the formatted character group caption according to
the specified custom sort order.}

\item{\code{customOrder}}{A vector values sorted into the desired order.}

\item{\code{sortOrder}}{Must be either "asc" or "desc".}

\item{\code{calculationGroupName}}{If sorting using a calculation, the name of the
calculation group containing the specified calculation.}

\item{\code{calculationName}}{If sorting using a calculation, the name of the
calculation.}

\item{\code{fromIndex}}{A boundary to limit the sort operation.}

\item{\code{toIndex}}{A boundary to limit the sort operation.}

\item{\code{resetCells}}{Default `TRUE` to reset any cells that currently exist
in the pivot table and trigger a recalculation of the pivot table when
it is next rendered.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-setRowDataGroupHeader"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-setRowDataGroupHeader}{}}}
\subsection{Method \code{setRowDataGroupHeader()}}{
Set the row group header associated with a level of the row data group
hierarchy.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$setRowDataGroupHeader(levelNumber = NULL, header = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{levelNumber}}{An integer specifying the level number.}

\item{\code{header}}{A character value specifying the caption.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
By default, the row data groups (i.e. row headings) at the left of the pivot
table have no column headings.  This method can specify the headings, which
can be rendered by specifying the `showRowGroupHeaders=TRUE` in the render
methods.
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-addCalculationGroup"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-addCalculationGroup}{}}}
\subsection{Method \code{addCalculationGroup()}}{
Create a new calculation group.  This is rarely needed since the
default group is sufficient for all regular pivot tables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$addCalculationGroup(calculationGroupName = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{calculationGroupName}}{The name of the new calculation group to create.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A `PivotCalculationGroup` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-defineCalculation"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-defineCalculation}{}}}
\subsection{Method \code{defineCalculation()}}{
Create a new `PivotCalculation` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$defineCalculation(
  calculationGroupName = "default",
  calculationName = NULL,
  caption = NULL,
  visible = TRUE,
  displayOrder = NULL,
  filters = NULL,
  format = NULL,
  fmtFuncArgs = NULL,
  dataName = NULL,
  type = "summary",
  valueName = NULL,
  summariseExpression = NULL,
  calculationExpression = NULL,
  calculationFunction = NULL,
  calcFuncArgs = NULL,
  basedOn = NULL,
  noDataValue = NULL,
  noDataCaption = NULL,
  headingBaseStyleName = NULL,
  headingStyleDeclarations = NULL,
  cellBaseStyleName = NULL,
  cellStyleDeclarations = NULL,
  resetCells = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{calculationGroupName}}{The name of the calculation group this
calculation will belong to.  The default calculation group will be
used if this parameter is not specified (this is sufficient for all
regular pivot tables).}

\item{\code{calculationName}}{Calculation unique name.}

\item{\code{caption}}{Calculation display name}

\item{\code{visible}}{`TRUE` to show the calculation in the pivot table or `FALSE`
to hide it.  Hidden calculations are typically used as base values for
other calculations.}

\item{\code{displayOrder}}{The order the calculations are displayed in the
pivot table.}

\item{\code{filters}}{Any additional data filters specific to this calculation.
This can be a `PivotFilters` object that further restricts the data for the
calculation or a list of individual `PivotFilter` objects that provide more
flexibility (and/or/replace).  See the Calculations vignette for details.}

\item{\code{format}}{A character, list or custom function to format the calculation
result.}

\item{\code{fmtFuncArgs}}{A list that specifies any additional arguments to pass to
a custom format function.}

\item{\code{dataName}}{Specifies which data frame in the pivot table is used for
this calculation (as specified in `pt$addData()`).}

\item{\code{type}}{The calculation type:  "summary", "calculation", "function" or
"value".}

\item{\code{valueName}}{For type="value", the name of the column containing the
value to display in the pivot table.}

\item{\code{summariseExpression}}{For type="summary", either the dplyr expression to
use with dplyr::summarise() or a data.table calculation expression.}

\item{\code{calculationExpression}}{For type="calculation", an expression to combine
aggregate values.}

\item{\code{calculationFunction}}{For type="function", a reference to a custom R
function that will carry out the calculation.}

\item{\code{calcFuncArgs}}{For type="function", a list that specifies additional
arguments to pass to calculationFunction.}

\item{\code{basedOn}}{A character vector specifying the names of one or more
calculations that this calculation depends on.}

\item{\code{noDataValue}}{An integer or numeric value specifying the value to use if
no data exists for a particular cell.}

\item{\code{noDataCaption}}{A character value that will be displayed by the pivot
table if no  data exists for a particular cell.}

\item{\code{headingBaseStyleName}}{The name of a style defined in the pivot table
to use as the base styling for the data group heading.}

\item{\code{headingStyleDeclarations}}{A list of CSS style declarations (e.g.
`list("font-weight"="bold")`) to override the base style.}

\item{\code{cellBaseStyleName}}{The name of a style defined in the pivot table to
use as the base styling for the cells related to this calculation.}

\item{\code{cellStyleDeclarations}}{A list of CSS style declarations (e.g.
`list("font-weight"="bold")`) to override the base style.}

\item{\code{resetCells}}{Default `TRUE` to reset any cells that currently exist
in the pivot table and trigger a recalculation of the pivot table when
it is next rendered.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `PivotCalculation` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-addColumnCalculationGroups"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-addColumnCalculationGroups}{}}}
\subsection{Method \code{addColumnCalculationGroups()}}{
Set calculations on existing data groups or add multiple new groups
to the column data group hierarchy to represent calculations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$addColumnCalculationGroups(
  calculationGroupName = "default",
  atLevel = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{calculationGroupName}}{The name of the calculation group to add
into the data group hierarchy.}

\item{\code{atLevel}}{The level number that specifies where to add the new
groups.  Level 1 = on the first visible level of the hierarchy.
`NULL` = create a new level at the bottom of the hierarchy for the new
groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If only one calculation is defined in the pivot table, then the calculation
is set onto the existing column data groups (and no new groups are generated).
If multiple calculations are defined, then a new level of data groups is
added, e.g. if two calculations are defined, then two new data groups will
be created under each existing leaf-level column data group.
}

\subsection{Returns}{
A list of new `PivotDataGroup` objects that have been added.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-addRowCalculationGroups"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-addRowCalculationGroups}{}}}
\subsection{Method \code{addRowCalculationGroups()}}{
Set calculations on existing data groups or add multiple new groups
to the row data group hierarchy to represent calculations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$addRowCalculationGroups(
  calculationGroupName = "default",
  atLevel = NULL,
  outlineBefore = NULL,
  outlineAfter = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{calculationGroupName}}{The name of the calculation group to add
into the data group hierarchy.}

\item{\code{atLevel}}{The level number that specifies where to add the new
groups.  Level 1 = on the first visible level of the hierarchy.
`NULL` = create a new level at the bottom of the hierarchy for the new
groups.}

\item{\code{outlineBefore}}{Default `FALSE` to disable the creation of outline header
groups.  Specify either `TRUE` or a list of outline group settings to create
outline header groups.  See the "Regular Layout" vignette for details.}

\item{\code{outlineAfter}}{Default `FALSE` to disable the creation of outline footer
groups.  Specify either `TRUE` or a list of outline group settings to create
outline footer groups.  See the "Regular Layout" vignette for details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If only one calculation is defined in the pivot table, then the calculation
is set onto the existing row data groups (and no new groups are generated).
If multiple calculations are defined, then a new level of data groups is
added, e.g. if two calculations are defined, then two new data groups will
be created under each existing leaf-level row data group.
}

\subsection{Returns}{
A list of new `PivotDataGroup` objects that have been added.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-addStyle"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-addStyle}{}}}
\subsection{Method \code{addStyle()}}{
Add a new named style to the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$addStyle(styleName = NULL, declarations = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{styleName}}{The name of the new style.}

\item{\code{declarations}}{CSS style declarations in the form of a list, e.g.
`list("font-weight"="bold", "color"="#0000FF")`}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The newly created `PivotStyle` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-createInlineStyle"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-createInlineStyle}{}}}
\subsection{Method \code{createInlineStyle()}}{
Create an inline style that can be used to override a base style.
For general use cases, the `setStyling()` method provides a simpler
and more direct way of styling specific parts of a pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$createInlineStyle(baseStyleName = NULL, declarations = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{baseStyleName}}{The name of an existing style to base the new style on.}

\item{\code{declarations}}{CSS style declarations in the form of a list, e.g.
`list("font-weight"="bold", "color"="#0000FF")`}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Inline styles are typically used to override the style of some specific
cells in a pivot table.  Inline styles have no name.
In HTML, they are rendered as 'style' attributes on specific table cells,
where as named styles are linked to cells using the 'class' attribute.
}

\subsection{Returns}{
The newly created `PivotStyle` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-setStyling"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-setStyling}{}}}
\subsection{Method \code{setStyling()}}{
Apply styling to a set of data groups or cells in a pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$setStyling(
  rFrom = NULL,
  cFrom = NULL,
  rTo = NULL,
  cTo = NULL,
  rowNumbers = NULL,
  columnNumbers = NULL,
  groups = NULL,
  cells = NULL,
  baseStyleName = NULL,
  style = NULL,
  declarations = NULL,
  applyBorderToAdjacentCells = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rFrom}}{An integer row number that specifies the start row for the
styling changes.}

\item{\code{cFrom}}{An integer column number that specifies the start column for the
styling changes.}

\item{\code{rTo}}{An integer row number that specifies the end row for the styling
changes.}

\item{\code{cTo}}{An integer column number that specifies the end column for the
styling changes.}

\item{\code{rowNumbers}}{An integer vector that specifies the row numbers for the
styling changes.}

\item{\code{columnNumbers}}{An integer vector that specifies the column numbers for
the styling changes.}

\item{\code{groups}}{A list containing `PivotDataGroup` objects.}

\item{\code{cells}}{A list containing `PivotCell` objects.}

\item{\code{baseStyleName}}{The name of a style to apply.}

\item{\code{style}}{A `PivotStyle` object to apply.}

\item{\code{declarations}}{CSS style declarations to apply in the form of a list,
e.g. `list("font-weight"="bold", "color"="#0000FF")`}

\item{\code{applyBorderToAdjacentCells}}{TRUE to override the border in
neighbouring cells, e.g. the left border of the current cell becomes the
right border of the cell to the left.  Does not apply to row/column groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
There are five ways to specify the part(s) of a pivot table to apply
styling to:\cr
(1) By specifying a list of data groups using the `groups` argument.\cr
(2) By specifying a list of cells using the `cells` argument.\cr
(3) By specifying a single cell using the `rFrom` and `cFrom` arguments.\cr
(4) By specifying a rectangular cell range using the `rFrom`, `cFrom`,
`rTo` and `cTo` arguments.\cr
(5) By specifying a vector of rowNumbers and/or columnNumbers.  If both
rowNumbers and columnNumbers are specified, then the cells at the
intersection of the specified row numbers and column numbers are styled.\cr
If both rFrom/rTo and rowNumbers are specified, then rFrom/rTo constrain
the row numbers specified in rowNumbers.\cr
If both cFrom/cTo and columnNumbers are specified, then cFrom/cTo constrain
the column numbers specified in columnNumbers.\cr
See the "Styling" and "Finding and Formatting" vignettes for more
information and many examples.
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-mapStyling"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-mapStyling}{}}}
\subsection{Method \code{mapStyling()}}{
Apply styling to pivot table cells based on the value of each cell.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$mapStyling(
  styleProperty = NULL,
  cells = NULL,
  valueType = "text",
  mapType = "range",
  mappings = NULL,
  styleLowerValues = FALSE,
  styleHigherValues = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{styleProperty}}{The name of the style property to set on the specified
cells, e.g. background-color.}

\item{\code{cells}}{A list containing `PivotCell` objects.}

\item{\code{valueType}}{The type of style value to be set.  Must be one of:
"text", "character", "number", "numeric", "color" or "colour".\cr
"text" and "character" are equivalent.  "number" and "numeric" are equivalent.
"color" and "colour" are equivalent.}

\item{\code{mapType}}{The type of mapping to be performed.  The following mapping
types are supported:\cr
(1) "value" = a 1:1 mapping which maps each specified "from" value to the
corresponding "to" value, e.g. 100 -> "green".\cr
(2) "logic" = each from value is logical criteria.  See details.\cr
(3) "range" = values between each pair of "from" values are mapped to the
corresponding "to" value, e.g. values in the range 80-100 -> "green" (more
specifically values greater than or equal to 80 and less than 100).\cr
(4) "continuous" = rescales values between each pair of "from" values into
the range of the corresponding pair of "to" values, e.g. if the "from" range
is 80-100 and the corresponding "to" range is 0.8-1, then 90 -> 0.9.\cr
"continuous" cannot be used with valueType="text"/"character".}

\item{\code{mappings}}{The mappings to be applied, specified in one of the following
three forms:\cr
(1) a list containing pairs of values, e.g.
`list(0, "red", 0.4, "yellow", 0.8, "green")`.\cr
(2) a list containing "from" and "to" vectors/lists, e.g.
`list(from=c(0, 0.4, 0.8), to=c("red", "yellow", "green"))`.\cr
(3) a custom mapping function that will be invoked once per cell, e.g.
`function(v, cell) { if(isTRUE(v>0.8)) return("green") }`.\cr
Mappings must be specified in ascending order when valueType="range" or
valueType="continuous".\cr
If a custom mapping function is specified, then the valueType and mapType
parameters are ignored.}

\item{\code{styleLowerValues}}{A logical value, default `FALSE`, that specifies
whether values less than the lowest specified "from" value should be styled
using the style specified for the lowest "from" value.  Only applies when
valueType="range" or valueType="continuous".}

\item{\code{styleHigherValues}}{A logical value, default `TRUE`, that specifies
whether values greater than the highest specified "from" value should be styled
using the style specified for the highest "from" value.  Only applies when
valueType="range" or valueType="continuous".}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
`mapStyling()` is typically used to conditionally apply styling to cells
based on the value of each individual cell, e.g. cells with values less
than a specified number could be coloured red.\cr
mapType="logic" maps values matching specified logical criteria to
specific "to" values.  The logical criteria can be any of the following
forms (the first matching mapping is used):\cr
(1) a specific value, e.g. 12.\cr
(2) a specific value equality condition, e.g. "v==12", where v
represents the cell value.\cr
(3) a value range expression using the following abbreviated form:
"value1<=v<value2", e.g. "10<=v<15".  Only "<" or "<=" can be used
in these value range expressions.\cr
(4) a standard R logical expression, e.g.
"10<=v && v<15".\cr
Basic R functions that test the value can also be
used, e.g. is.na(v).\cr
See the "Styling" and Finding and Formatting" vignettes for more
information and many examples.
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-generateCellStructure"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-generateCellStructure}{}}}
\subsection{Method \code{generateCellStructure()}}{
Generate the cells that will form the body of the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$generateCellStructure()}\if{html}{\out{</div>}}
}

\subsection{Details}{
This method rarely needs to be called explicitly, since other methods will
invoke it if needed.
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-resetCells"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-resetCells}{}}}
\subsection{Method \code{resetCells()}}{
Clear the cells of the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$resetCells()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The cells are reset automatically when structural changes are made to the
pivot table, so this method rarely needs to be called explicitly.
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-evaluateCells"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-evaluateCells}{}}}
\subsection{Method \code{evaluateCells()}}{
Calculate the cell values in the body of the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$evaluateCells()}\if{html}{\out{</div>}}
}

\subsection{Details}{
This method rarely needs to be called explicitly, since other methods will
invoke it if needed.
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-evaluatePivot"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-evaluatePivot}{}}}
\subsection{Method \code{evaluatePivot()}}{
Calculate the cell values in the body of the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$evaluatePivot()}\if{html}{\out{</div>}}
}

\subsection{Details}{
This generally only needs to be called explicitly if specific pivot cells
need to be further processed (e.g. formatted) before the pivot table is
rendered.\cr
This method is a wrapper for calling `normaliseColumnGroups()`,
`normaliseRowGroups()`, `generateCellStructure()` and `evaluateCells()`
in sequence.
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-findRowDataGroups"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-findRowDataGroups}{}}}
\subsection{Method \code{findRowDataGroups()}}{
Find row data groups that match specified criteria.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$findRowDataGroups(
  matchMode = "simple",
  variableNames = NULL,
  variableValues = NULL,
  totals = "include",
  calculationNames = NULL,
  atLevels = NULL,
  minChildCount = NULL,
  maxChildCount = NULL,
  emptyGroups = "exclude",
  outlineGroups = "exclude",
  outlineLinkedGroupExists = NULL,
  includeDescendantGroups = FALSE,
  rowNumbers = NULL,
  cells = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{matchMode}}{Either "simple" (default) or "combinations".\cr
"simple" is used when matching only one variable-value, multiple
variable-value combinations are effectively logical "OR".\cr
"combinations" is used when matching for combinations of variable
values, multiple variable-value combinations are effectively
logical "AND".  A child group is viewed as having the variable-value
filters of itself and it's parent/ancestors, e.g.\cr
`list("TrainCategory"="Express Passenger", "PowerType"="DMU")`,
would return the "DMU" data group underneath "Express Passenger".\cr
See the "Finding and Formatting" vignette for graphical examples.}

\item{\code{variableNames}}{A character vector specifying the name/names of the
variables to find.  This is useful generally only in pivot tables with
irregular layouts, since in regular pivot tables every cell is related
to every variable.}

\item{\code{variableValues}}{A list specifying the variable names and values to find,
e.g. `variableValues=list("PowerType"=c("DMU", "HST"))`.\cr
Specify "**" as the variable value to match totals for the specified variable.\cr
Specify "!*" as the variable value to match non-totals for the specified variable.\cr
NB: The totals/non-totals criteria above won’t work when visual totals are used.\cr}

\item{\code{totals}}{A word that specifies how totals are matched (overrides the finer
settings above) - must be one of "include" (default), "exclude" or "only".}

\item{\code{calculationNames}}{A character vector specifying the name/names of the
calculations to find.}

\item{\code{atLevels}}{An integer vector constraining the levels in the hierarchy to
search.}

\item{\code{minChildCount}}{Match only data groups with this minimum number of children.}

\item{\code{maxChildCount}}{Match only data groups with this maximum number of children.}

\item{\code{emptyGroups}}{A word that specifies how empty groups are matched -
must be one of "include", "exclude" (default) or "only".}

\item{\code{outlineGroups}}{A word that specifies how outline cells are matched -
must be one of "include", "exclude" (default) or "only".}

\item{\code{outlineLinkedGroupExists}}{`TRUE` to match only groups where the related
outline child group still exists.  `FALSE` to match only groups where the related
outline child group no longer exists.}

\item{\code{includeDescendantGroups}}{Default `FALSE`.  Specify true to also return
all descendants of data groups that match the specified criteria.}

\item{\code{rowNumbers}}{An integer vector specifying row numbers that constrains
the data groups to be found.}

\item{\code{cells}}{A `PivotCell` object or a list of `PivotCell` objects to specify
one or more cells that must intersect the data groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of data groups matching the specified criteria.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-findColumnDataGroups"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-findColumnDataGroups}{}}}
\subsection{Method \code{findColumnDataGroups()}}{
Find column data groups that match specified criteria.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$findColumnDataGroups(
  matchMode = "simple",
  variableNames = NULL,
  variableValues = NULL,
  totals = "include",
  calculationNames = NULL,
  atLevels = NULL,
  minChildCount = NULL,
  maxChildCount = NULL,
  emptyGroups = "exclude",
  includeDescendantGroups = FALSE,
  columnNumbers = NULL,
  cells = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{matchMode}}{Either "simple" (default) or "combinations".\cr
"simple" is used when matching only one variable-value - multiple
variable-value combinations are effectively logical "OR".\cr
"combinations" is used when matching for combinations of variable
values - multiple variable-value combinations are effectively
logical "AND".  A child group is viewed as having the variable-value
filters of itself and it's parent/ancestors, e.g.\cr
`list("TrainCategory"="Express Passenger", "PowerType"="DMU")`,
would return the "DMU" data group underneath "Express Passenger".\cr
See the "Finding and Formatting" vignette for graphical examples.}

\item{\code{variableNames}}{A character vector specifying the name/names of the
variables to find.  This is useful generally only in pivot tables with
irregular layouts, since in regular pivot tables every cell is related
to every variable.}

\item{\code{variableValues}}{A list specifying the variable names and values to find,
e.g. `variableValues=list("PowerType"=c("DMU", "HST"))`.\cr
Specify "**" as the variable value to match totals for the specified variable.\cr
Specify "!*" as the variable value to match non-totals for the specified variable.\cr
NB: The totals/non-totals criteria above won’t work when visual totals are used.}

\item{\code{totals}}{A word that specifies how totals are matched (overrides the finer
settings above) - must be one of "include" (default), "exclude" or "only".}

\item{\code{calculationNames}}{A character vector specifying the name/names of the
calculations to find.}

\item{\code{atLevels}}{An integer vector constraining the levels in the hierarchy to
search.}

\item{\code{minChildCount}}{Match only data groups with this minimum number of children.}

\item{\code{maxChildCount}}{Match only data groups with this maximum number of children.}

\item{\code{emptyGroups}}{A word that specifies how empty groups are matched -
must be one of "include", "exclude" (default) or "only".}

\item{\code{includeDescendantGroups}}{Default `FALSE`.  Specify true to also return
all descendants of data groups that match the specified criteria.}

\item{\code{columnNumbers}}{An integer vector specifying column numbers that constrains
the data groups to be found.}

\item{\code{cells}}{A `PivotCell` object or a list of `PivotCell` objects to specify
one or more cells that must intersect the data groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of data groups matching the specified criteria.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getEmptyRows"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getEmptyRows}{}}}
\subsection{Method \code{getEmptyRows()}}{
Retrieve row numbers for rows where all cells are empty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getEmptyRows(
  NAasEmpty = TRUE,
  zeroAsEmpty = FALSE,
  zeroTolerance = 1e-06,
  includeOutlineRows = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{NAasEmpty}}{`TRUE` (default) specifies that `NA` is treated as empty.}

\item{\code{zeroAsEmpty}}{`TRUE` specifies that zero is treated as empty,
default `FALSE`.}

\item{\code{zeroTolerance}}{The tolerance for zero comparisons, default 0.000001.}

\item{\code{includeOutlineRows}}{`TRUE` to also examine outline rows, default `FALSE`.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
`NULL` cell values are always regarded as empty.
}

\subsection{Returns}{
An integer vector of row numbers.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getEmptyColumns"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getEmptyColumns}{}}}
\subsection{Method \code{getEmptyColumns()}}{
Retrieve column numbers for columns where all cells are empty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getEmptyColumns(
  NAasEmpty = TRUE,
  zeroAsEmpty = FALSE,
  zeroTolerance = 1e-06
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{NAasEmpty}}{`TRUE` (default) specifies that `NA` is treated as empty.}

\item{\code{zeroAsEmpty}}{`TRUE` specifies that zero is treated as empty,
default `FALSE`.}

\item{\code{zeroTolerance}}{The tolerance for zero comparisons, default 0.000001.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
`NULL` cell values are always regarded as empty.
}

\subsection{Returns}{
An integer vector of column numbers.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getCell"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getCell}{}}}
\subsection{Method \code{getCell()}}{
Get the cell at the specified row and column coordinates in the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getCell(r = NULL, c = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{r}}{Row number of the cell to retrieve.}

\item{\code{c}}{Column number of the cell to retrieve.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The row and column numbers refer only to the cells in the body of the pivot
table, i.e. row and column headings are excluded, e.g. row 1 is the first
row of cells underneath the column headings.
}

\subsection{Returns}{
A `PivotCell` object representing the cell.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getCells"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getCells}{}}}
\subsection{Method \code{getCells()}}{
Retrieve cells by a combination of row and/or column numbers.
See the "Finding and Formatting" vignette for graphical examples.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getCells(
  specifyCellsAsList = TRUE,
  rowNumbers = NULL,
  columnNumbers = NULL,
  cellCoordinates = NULL,
  excludeEmptyCells = FALSE,
  groups = NULL,
  rowGroups = NULL,
  columnGroups = NULL,
  matchMode = "simple"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{specifyCellsAsList}}{Specify how cells are retrieved.
Default `TRUE`. More information is provided in the details section.}

\item{\code{rowNumbers}}{A vector of row numbers that specify the rows or
cells to retrieve.}

\item{\code{columnNumbers}}{A vector of column numbers that specify the columns
or cells to retrieve.}

\item{\code{cellCoordinates}}{A list of two-element vectors that specify the
coordinates of cells to retrieve.  Ignored when `specifyCellsAsList=FALSE`.}

\item{\code{excludeEmptyCells}}{Default `FALSE`.  Specify `TRUE` to exclude empty
cells.}

\item{\code{groups}}{A `PivotDataGroup` object or a list of `PivotDataGroup`
objects on either the rows or columns axes.  The cells to be retrieved
must be related to at least one of these groups.}

\item{\code{rowGroups}}{A `PivotDataGroup` object or a list of `PivotDataGroup`
objects on the rows axis.  The cells to be retrieved must be related to
at least one of these row groups.  If both `rowGroups` and `columnGroups`
are specified, then the cells to be retrieved must be related to at least
one of the specified row groups and one of the specified column groups.}

\item{\code{columnGroups}}{A `PivotDataGroup` object or a list of `PivotDataGroup`
objects on the columns axis.  The cells to be retrieved must be related to
at least one of these column groups.  If both `rowGroups` and `columnGroups`
are specified, then the cells to be retrieved must be related to at least
one of the specified row groups and one of the specified column groups.}

\item{\code{matchMode}}{Either "simple" (default) or "combinations":\cr
"simple" specifies that row and column arguments are considered separately
(logical OR), e.g. rowNumbers=1 and columnNumbers=2 will match all cells in
row 1 and all cells in column 2.\cr
"combinations" specifies that row and column arguments are considered together
(logical AND), e.g. rowNumbers=1 and columnNumbers=2 will match only the
cell single at location (1, 2).\cr
Arguments `rowNumbers`, `columnNumbers`, `rowGroups` and `columnGroups` are
affected by the match mode.  All other arguments are not.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
When `specifyCellsAsList=TRUE` (the default):\cr
Get one or more rows by specifying the row numbers as a vector as
the rowNumbers argument and leaving the columnNumbers argument set
to the default value of `NULL`, or\cr
Get one or more columns by specifying the column numbers as a vector
as the columnNumbers argument and leaving the rowNumbers argument
set to the default value of `NULL`, or\cr
Get one or more individual cells by specifying the cellCoordinates
argument as a list of vectors of length 2, where each element in the
list is the row and column number of one cell,\cr
e.g. `list(c(1, 2), c(3, 4))` specifies two cells, the first located
at row 1, column 2 and the second located at row 3, column 4.\cr
When `specifyCellsAsList=FALSE`:\cr
Get one or more rows by specifying the row numbers as a vector as the
rowNumbers argument and leaving the columnNumbers argument set to the
default value of `NULL`, or\cr
Get one or more columns by specifying the column numbers as a vector
as the columnNumbers argument and leaving the rowNumbers argument set
to the default value of `NULL`, or\cr
Get one or more cells by specifying the row and column numbers as vectors
for the rowNumbers and columnNumbers arguments, or\cr
a mixture of the above, where for entire rows/columns the element in the
other vector is set to `NA`, e.g. to retrieve whole rows, specify the row
numbers as the rowNumbers but set the corresponding elements in the
columnNumbers vector to `NA`.
}

\subsection{Returns}{
A list of `PivotCell` objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-findCells"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-findCells}{}}}
\subsection{Method \code{findCells()}}{
Find cells matching specified criteria.
See the "Finding and Formatting" vignette for graphical examples.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$findCells(
  variableNames = NULL,
  variableValues = NULL,
  totals = "include",
  calculationNames = NULL,
  minValue = NULL,
  maxValue = NULL,
  exactValues = NULL,
  valueRanges = NULL,
  includeNull = TRUE,
  includeNA = TRUE,
  emptyCells = "include",
  outlineCells = "exclude",
  rowNumbers = NULL,
  columnNumbers = NULL,
  cellCoordinates = NULL,
  groups = NULL,
  rowGroups = NULL,
  columnGroups = NULL,
  rowColumnMatchMode = "simple",
  cells = NULL,
  lowN = NULL,
  highN = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{variableNames}}{A character vector specifying the name/names of the
variables to find.  This is useful generally only in pivot tables with
irregular layouts, since in regular pivot tables every cell is related
to every variable.}

\item{\code{variableValues}}{A list specifying the variable names and values to find,
e.g. `variableValues=list("PowerType"=c("DMU", "HST"))`.\cr
Specify "**" as the variable value to match totals for the specified variable.\cr
Specify "!*" as the variable value to match non-totals for the specified variable.\cr
NB: The totals/non-totals criteria above won’t work when visual totals are used.}

\item{\code{totals}}{A word that specifies how totals are matched (overrides the finer
settings above) - must be one of "include" (default), "exclude" or "only".}

\item{\code{calculationNames}}{A character vector specifying the name/names of the
calculations to find.}

\item{\code{minValue}}{A numerical value specifying a minimum value threshold.}

\item{\code{maxValue}}{A numerical value specifying a maximum value threshold.}

\item{\code{exactValues}}{A vector or list specifying a set of allowed values.}

\item{\code{valueRanges}}{A vector specifying one or more value range expressions which
the cell values must match.  If multiple value range expressions are specified,
then the cell value must match any of one the specified expressions.  See details.}

\item{\code{includeNull}}{specify TRUE to include `NULL` in the matched cells,
FALSE to exclude `NULL` values.}

\item{\code{includeNA}}{specify TRUE to include `NA` in the matched cells,
FALSE to exclude `NA` values.}

\item{\code{emptyCells}}{A word that specifies how empty cells are matched -
must be one of "include" (default), "exclude" or "only".}

\item{\code{outlineCells}}{A word that specifies how outline cells are matched -
must be one of "include", "exclude" (default) or "only".}

\item{\code{rowNumbers}}{A vector of row numbers that specify the rows or
cells to constrain the search.}

\item{\code{columnNumbers}}{A vector of column numbers that specify the columns
or cells to constrain the search.}

\item{\code{cellCoordinates}}{A list of two-element vectors that specify the
coordinates of cells to constrain the search.}

\item{\code{groups}}{A `PivotDataGroup` object or a list of `PivotDataGroup`
objects on either the rows or columns axes.  The cells to be searched
must be related to at least one of these groups.}

\item{\code{rowGroups}}{A `PivotDataGroup` object or a list of `PivotDataGroup`
objects on the rows axis.  The cells to be searched must be related to
at least one of these row groups.  If both `rowGroups` and `columnGroups`
are specified, then the cells to be searched must be related to at least
one of the specified row groups and one of the specified column groups.}

\item{\code{columnGroups}}{A `PivotDataGroup` object or a list of `PivotDataGroup`
objects on the columns axis.  The cells to be searched must be related to
at least one of these column groups.  If both `rowGroups` and `columnGroups`
are specified, then the cells to be searched must be related to at least
one of the specified row groups and one of the specified column groups.}

\item{\code{rowColumnMatchMode}}{Either "simple" (default) or "combinations":\cr
"simple" specifies that row and column arguments are considered separately
(logical OR), e.g. rowNumbers=1 and columnNumbers=2 will match all cells in
row 1 and all cells in column 2.\cr
"combinations" specifies that row and column arguments are considered together
(logical AND), e.g. rowNumbers=1 and columnNumbers=2 will match only the
cell single at location (1, 2).\cr
Arguments `rowNumbers`, `columnNumbers`, `rowGroups` and `columnGroups` are
affected by the match mode.  All other arguments are not.}

\item{\code{cells}}{A `PivotCell` object or a list of `PivotCell`
objects to constrain the scope of the search.}

\item{\code{lowN}}{Find the first N cells (ascending order, lowest values first).}

\item{\code{highN}}{Find the last N cells (descending order, highest values first).}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The valueRanges parameter can be any of the following
forms:\cr
(1) a specific value, e.g. 12.\cr
(2) a specific value equality condition, e.g. "v==12", where v
represents the cell value.\cr
(3) a value range expression using the following abbreviated form:
"value1<=v<value2", e.g. "10<=v<15".  Only "<" or "<=" can be used
in these value range expressions.\cr
(4) a standard R logical expression, e.g.
"10<=v && v<15".\cr
Basic R functions that test the value can also be
used, e.g. is.na(v).\cr
}

\subsection{Returns}{
A list of `PivotCell` objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-findGroupColumnNumbers"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-findGroupColumnNumbers}{}}}
\subsection{Method \code{findGroupColumnNumbers()}}{
Find the column numbers associated with a specific data group or
groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$findGroupColumnNumbers(group = NULL, collapse = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{A `PivotDataGroup` in the column data groups (i.e. a
column heading) or a list of column data groups.}

\item{\code{collapse}}{A logical value specifying whether the return value should be
simplified.  See details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If `group` is a list:  If `collapse` is `FALSE`, then a list of vectors is
returned, if `collapse` is `TRUE`, then a single combined vector is returned.
}

\subsection{Returns}{
Either a vector of column numbers related to the single specified group
or a list of vectors containing column numbers related to the specified groups.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-findGroupRowNumbers"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-findGroupRowNumbers}{}}}
\subsection{Method \code{findGroupRowNumbers()}}{
Find the row numbers associated with a specific data group or groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$findGroupRowNumbers(group = NULL, collapse = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{A `PivotDataGroup` in the row data groups (i.e. a
row heading) or a list of row data groups.}

\item{\code{collapse}}{A logical value specifying whether the return value should be
simplified.  See details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If `group` is a list:  If `collapse` is `FALSE`, then a list of vectors is
returned, if `collapse` is `TRUE`, then a single combined vector is returned.
}

\subsection{Returns}{
Either a vector of row numbers related to the single specified group
or a list of vectors containing row numbers related to the specified groups.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-removeColumn"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-removeColumn}{}}}
\subsection{Method \code{removeColumn()}}{
Remove a column from the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$removeColumn(c = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{c}}{The column number.  The first column is column 1, excluding the
column(s) associated with row-headings.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method removes both the related column group and cells.
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-removeColumns"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-removeColumns}{}}}
\subsection{Method \code{removeColumns()}}{
Remove multiple column from the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$removeColumns(columnNumbers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{columnNumbers}}{The column numbers.  The first column is column 1, excluding the
column(s) associated with row-headings.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method removes both the related column groups and cells.
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-removeEmptyColumns"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-removeEmptyColumns}{}}}
\subsection{Method \code{removeEmptyColumns()}}{
Remove columns where all cells are empty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$removeEmptyColumns(
  NAasEmpty = TRUE,
  zeroAsEmpty = FALSE,
  zeroTolerance = 1e-06
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{NAasEmpty}}{`TRUE` (default) specifies that `NA` is treated as empty.}

\item{\code{zeroAsEmpty}}{`TRUE` specifies that zero is treated as empty,
default `FALSE`.}

\item{\code{zeroTolerance}}{The tolerance for zero comparisons, default 0.000001.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
`NULL` cell values are always regarded as empty.
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-removeRow"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-removeRow}{}}}
\subsection{Method \code{removeRow()}}{
Remove a row from the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$removeRow(r = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{r}}{The row number.  The first row is row 1, excluding the
row(s) associated with column-headings.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method removes both the related row group and cells.
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-removeRows"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-removeRows}{}}}
\subsection{Method \code{removeRows()}}{
Remove multiple rows from the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$removeRows(rowNumbers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rowNumbers}}{The row numbers.  The first row is row 1, excluding the
rows(s) associated with column-headings.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method removes both the related row groups and cells.
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-removeEmptyRows"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-removeEmptyRows}{}}}
\subsection{Method \code{removeEmptyRows()}}{
Remove rows where all cells are empty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$removeEmptyRows(
  NAasEmpty = TRUE,
  zeroAsEmpty = FALSE,
  zeroTolerance = 1e-06,
  includeOutlineRows = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{NAasEmpty}}{`TRUE` (default) specifies that `NA` is treated as empty.}

\item{\code{zeroAsEmpty}}{`TRUE` specifies that zero is treated as empty,
default `FALSE`.}

\item{\code{zeroTolerance}}{The tolerance for zero comparisons, default 0.000001.}

\item{\code{includeOutlineRows}}{`TRUE` to also remove empty outline rows,
default `FALSE`.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
`NULL` cell values are always regarded as empty.
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-print"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-print}{}}}
\subsection{Method \code{print()}}{
Outputs a plain text representation of the pivot table to the console or
returns a character representation of the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$print(asCharacter = FALSE, showRowGroupHeaders = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{asCharacter}}{`FALSE`(default) outputs to the console, specify `TRUE`
to instead return a character value (does not output to console).}

\item{\code{showRowGroupHeaders}}{`TRUE` to include the row group headers in the
output, default `FALSE`.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Plain text representation of the pivot table.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-asMatrix"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-asMatrix}{}}}
\subsection{Method \code{asMatrix()}}{
Convert the pivot table to a matrix, where the data group headings
are included in the body of the matrix.  This method tends to produce
a character matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$asMatrix(
  includeHeaders = TRUE,
  repeatHeaders = FALSE,
  rawValue = FALSE,
  showRowGroupHeaders = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{includeHeaders}}{`TRUE` (default) to include the headings in the
body of the matrix.  Specifying `FALSE` omits the headings.}

\item{\code{repeatHeaders}}{`FALSE` (default) only outputs the first occurrence of each
header. Specify `TRUE` to repeat the headings.}

\item{\code{rawValue}}{`FALSE` (default) outputs the formatted (character) values.
Specify `TRUE` to output the raw cell values.}

\item{\code{showRowGroupHeaders}}{`TRUE` to include the row group headers in the
matrix, default `FALSE`.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The newer `asDataMatrix()` tends to produce more a useful matrix.
See the "Outputs" vignette for a comparison of outputs.
}

\subsection{Returns}{
A matrix.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-asDataMatrix"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-asDataMatrix}{}}}
\subsection{Method \code{asDataMatrix()}}{
Convert the pivot table to a matrix, where the data group headings
are included as row/column headings in the matrix.
This method tends to produce a numeric matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$asDataMatrix(
  includeHeaders = TRUE,
  rawValue = TRUE,
  separator = " "
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{includeHeaders}}{`TRUE` (default) to include the headings in the matrix.
Specifying `FALSE` omits the headings.}

\item{\code{rawValue}}{`TRUE` (default) outputs the raw cell values.
Specify `FALSE` to output the formatted (character) values.}

\item{\code{separator}}{Specifies the character value used to concatenate data
group captions where multiple levels exist in the data group hierarchy.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Where there are multiple levels in a data group hierarchy, the captions are
concatenated to form the row/column headings in the matrix.
See the "Outputs" vignette for a comparison of outputs.
}

\subsection{Returns}{
A matrix.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-asDataFrame"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-asDataFrame}{}}}
\subsection{Method \code{asDataFrame()}}{
Convert the pivot table to a data frame, combining multiple levels of
headings with the specified separator and/or exporting the row groups
as columns in the data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$asDataFrame(
  separator = " ",
  stringsAsFactors = NULL,
  forceNumeric = FALSE,
  rowGroupsAsColumns = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{separator}}{Specifies the character value used to concatenate data
group captions where multiple levels exist in the data group hierarchy.}

\item{\code{stringsAsFactors}}{Specify `TRUE` to convert strings to factors,
default is `default.stringsAsFactors()` for R < 4.1.0 and `FALSE`
for R >= 4.1.0.}

\item{\code{forceNumeric}}{Specify `TRUE` to force the conversion of cell values
to a numeric value, default `FALSE`.}

\item{\code{rowGroupsAsColumns}}{Specify `TRUE` to include the row groups as
additional columns in the data frame.  Default `FALSE`.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See the "Outputs" vignette for more details and examples
}

\subsection{Returns}{
A data frame.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-asTidyDataFrame"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-asTidyDataFrame}{}}}
\subsection{Method \code{asTidyDataFrame()}}{
Convert the pivot table to tidy data frame, where each cell in the body of
the pivot table becomes one row in the data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$asTidyDataFrame(
  includeGroupCaptions = TRUE,
  includeGroupValues = TRUE,
  separator = " ",
  stringsAsFactors = NULL,
  excludeEmptyCells = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{includeGroupCaptions}}{`TRUE` (default) to include the data group
captions as columns in the data frame.}

\item{\code{includeGroupValues}}{`TRUE` (default) to include the data group
values as columns in the data frame.}

\item{\code{separator}}{Specifies the character value used to concatenate
filter values where multiple values exist in a filter.}

\item{\code{stringsAsFactors}}{Specify `TRUE` to convert strings to factors,
default is `default.stringsAsFactors()` for R < 4.1.0 and `FALSE`
for R >= 4.1.0.}

\item{\code{excludeEmptyCells}}{Specify `FALSE` to also include rows for
empty cells in the data frame, default `TRUE`.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See the "Outputs" vignette for more details and examples
}

\subsection{Returns}{
A data frame.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getMerges"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getMerges}{}}}
\subsection{Method \code{getMerges()}}{
Generate a list of the merged cell information arising from the data
group hierarchies.
This is an internal method used to support rendering the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getMerges(axis = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{axis}}{Either "row" or "column".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list containing details of the merged cells.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-asBasicTable"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-asBasicTable}{}}}
\subsection{Method \code{asBasicTable()}}{
Convert the pivot table to a `basictabler` table (from the `basictabler`
R package) which allows further custom manipulation of the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$asBasicTable(
  exportOptions = NULL,
  compatibility = NULL,
  showRowGroupHeaders = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{exportOptions}}{A list of additional export options - see the
"A1. Appendix" for details.}

\item{\code{compatibility}}{A list containing compatibility options to force
legacy behaviours in the resulting `basictabler` table.}

\item{\code{showRowGroupHeaders}}{`TRUE` to include the row group headers in the
matrix, default `FALSE`.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See the "Outputs" vignette for more details and examples
}

\subsection{Returns}{
A `basictabler` table.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getCss"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getCss}{}}}
\subsection{Method \code{getCss()}}{
Get the CSS declarations for the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getCss(styleNamePrefix = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{styleNamePrefix}}{A character variable specifying a prefix for all named
CSS styles, to avoid style name collisions where multiple pivot tables exist.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See the "Outputs" vignette for more details and examples.
}

\subsection{Returns}{
A character value containing the CSS style declaration.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getHtml"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getHtml}{}}}
\subsection{Method \code{getHtml()}}{
Generate a HTML representation of the pivot table, optionally including
additional detail for debugging purposes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getHtml(
  styleNamePrefix = NULL,
  includeHeaderValues = FALSE,
  includeRCFilters = FALSE,
  includeCalculationFilters = FALSE,
  includeWorkingData = FALSE,
  includeEvaluationFilters = FALSE,
  includeCalculationNames = FALSE,
  includeRawValue = FALSE,
  includeTotalInfo = FALSE,
  exportOptions = NULL,
  showRowGroupHeaders = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{styleNamePrefix}}{A character variable specifying a prefix for all named
CSS styles, to avoid style name collisions where multiple pivot tables exist.}

\item{\code{includeHeaderValues}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeRCFilters}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeCalculationFilters}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeWorkingData}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeEvaluationFilters}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeCalculationNames}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeRawValue}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeTotalInfo}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{exportOptions}}{A list of additional export options - see the
"A1. Appendix" for details.}

\item{\code{showRowGroupHeaders}}{Default `FALSE`, specify `TRUE` to render the row
group headings.  See the "Data Groups" vignette for details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See the "Outputs" vignette for more details and examples.
}

\subsection{Returns}{
A list containing HTML tags from the `htmltools` package.
Convert this to a character variable using `as.character()`.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-saveHtml"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-saveHtml}{}}}
\subsection{Method \code{saveHtml()}}{
Save a HTML representation of the pivot table to file, optionally including
additional detail for debugging purposes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$saveHtml(
  filePath = NULL,
  fullPageHTML = TRUE,
  styleNamePrefix = NULL,
  includeHeaderValues = FALSE,
  includeRCFilters = FALSE,
  includeCalculationFilters = FALSE,
  includeWorkingData = FALSE,
  includeEvaluationFilters = FALSE,
  includeCalculationNames = FALSE,
  includeRawValue = FALSE,
  includeTotalInfo = FALSE,
  exportOptions = NULL,
  showRowGroupHeaders = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filePath}}{The file to save the HTML to.}

\item{\code{fullPageHTML}}{`TRUE` (default) includes basic HTML around the pivot
table HTML so that the result file is a valid HTML file.}

\item{\code{styleNamePrefix}}{A character variable specifying a prefix for all named
CSS styles, to avoid style name collisions where multiple pivot tables exist.}

\item{\code{includeHeaderValues}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeRCFilters}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeCalculationFilters}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeWorkingData}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeEvaluationFilters}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeCalculationNames}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeRawValue}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeTotalInfo}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{exportOptions}}{A list of additional export options - see the
"A1. Appendix" for details.}

\item{\code{showRowGroupHeaders}}{Default `FALSE`, specify `TRUE` to render the row
group headings.  See the "Data Groups" vignette for details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See the "Outputs" vignette for more details and examples.
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-renderPivot"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-renderPivot}{}}}
\subsection{Method \code{renderPivot()}}{
Render a HTML representation of the pivot table as an HTML widget,
optionally including additional detail for debugging purposes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$renderPivot(
  width = NULL,
  height = NULL,
  styleNamePrefix = NULL,
  includeHeaderValues = FALSE,
  includeRCFilters = FALSE,
  includeCalculationFilters = FALSE,
  includeWorkingData = FALSE,
  includeEvaluationFilters = FALSE,
  includeCalculationNames = FALSE,
  includeRawValue = FALSE,
  includeTotalInfo = FALSE,
  exportOptions = NULL,
  showRowGroupHeaders = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{width}}{The width of the widget.}

\item{\code{height}}{The height of the widget.}

\item{\code{styleNamePrefix}}{A character variable specifying a prefix for all named
CSS styles, to avoid style name collisions where multiple pivot tables exist.}

\item{\code{includeHeaderValues}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeRCFilters}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeCalculationFilters}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeWorkingData}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeEvaluationFilters}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeCalculationNames}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeRawValue}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{includeTotalInfo}}{Default `FALSE`, specify `TRUE` to render
this debug information.}

\item{\code{exportOptions}}{A list of additional export options - see the
"A1. Appendix" for details.}

\item{\code{showRowGroupHeaders}}{Default `FALSE`, specify `TRUE` to render the row
group headings.  See the "Data Groups" vignette for details.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
See the "Outputs" vignette for more details and examples.
}

\subsection{Returns}{
A HTML widget from the `htmlwidgets` package.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-getLatex"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-getLatex}{}}}
\subsection{Method \code{getLatex()}}{
Generate a Latex representation of the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$getLatex(
  caption = NULL,
  label = NULL,
  fromRow = NULL,
  toRow = NULL,
  fromColumn = NULL,
  toColumn = NULL,
  boldHeadings = FALSE,
  italicHeadings = FALSE,
  exportOptions = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{caption}}{The caption to appear above the table.}

\item{\code{label}}{The label to use when referring to the table elsewhere in
the document}

\item{\code{fromRow}}{The row number to render from.}

\item{\code{toRow}}{The row number to render to.}

\item{\code{fromColumn}}{The column number to render from.}

\item{\code{toColumn}}{The column number to render to.}

\item{\code{boldHeadings}}{Default `FALSE`, specify `TRUE` to render headings
in bold.}

\item{\code{italicHeadings}}{Default `FALSE`, specify `TRUE` to render headings
in italic.}

\item{\code{exportOptions}}{A list of additional export options - see the
"A1. Appendix" for details.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character variable containing the Latex representation of
the pivot table.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-writeToExcelWorksheet"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-writeToExcelWorksheet}{}}}
\subsection{Method \code{writeToExcelWorksheet()}}{
Write the pivot table into the specified workbook and worksheet at
the specified row-column location.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$writeToExcelWorksheet(
  wb = NULL,
  wsName = NULL,
  topRowNumber = NULL,
  leftMostColumnNumber = NULL,
  outputHeadingsAs = "formattedValueAsText",
  outputValuesAs = "rawValue",
  applyStyles = TRUE,
  mapStylesFromCSS = TRUE,
  exportOptions = NULL,
  showRowGroupHeaders = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{wb}}{A `Workbook` object representing the Excel file being written
to.}

\item{\code{wsName}}{A character value specifying the name of the worksheet to
write to.}

\item{\code{topRowNumber}}{An integer value specifying the row number in the
Excel worksheet to write the pivot table.}

\item{\code{leftMostColumnNumber}}{An integer value specifying the column number
in the Excel worksheet to write the pivot table.}

\item{\code{outputHeadingsAs}}{Must be one of "rawValue",
"formattedValueAsText" (default) or "formattedValueAsNumber" to specify
how data groups are written into the Excel sheet.}

\item{\code{outputValuesAs}}{Must be one of "rawValue" (default),
"formattedValueAsText" or "formattedValueAsNumber" to specify
how cell values are written into the Excel sheet.}

\item{\code{applyStyles}}{Default `TRUE` to write styling information to the cell.}

\item{\code{mapStylesFromCSS}}{Default `TRUE` to automatically convert CSS style
declarations to their Excel equivalents.}

\item{\code{exportOptions}}{A list of additional export options - see the
"A1. Appendix" for details.}

\item{\code{showRowGroupHeaders}}{Default `FALSE`, specify `TRUE` to write row
group headers.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-trace"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-trace}{}}}
\subsection{Method \code{trace()}}{
Capture a call for tracing purposes.
This is an internal method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$trace(methodName, desc, detailList = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{methodName}}{The name of the method being invoked.}

\item{\code{desc}}{Short description of method call.}

\item{\code{detailList}}{A list containing detail such as parameter values.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-showBatchInfo"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-showBatchInfo}{}}}
\subsection{Method \code{showBatchInfo()}}{
Output batch information to the console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$showBatchInfo()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-asList"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-asList}{}}}
\subsection{Method \code{asList()}}{
Return the contents of the pivot table as a list for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$asList()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-asJSON"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-asJSON}{}}}
\subsection{Method \code{asJSON()}}{
Return the contents of the pivot table as JSON for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$asJSON()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A JSON representation of various object properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-viewJSON"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-viewJSON}{}}}
\subsection{Method \code{viewJSON()}}{
Use the `listviewer` package to view the pivot table as JSON for debugging.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$viewJSON()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-finalize}{}}}
\subsection{Method \code{finalize()}}{
Clean-up the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$finalize()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotTable-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PivotTable-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotTable$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
