% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pixieply.R
\name{pixieply}
\alias{pixiemap}
\alias{pixieply}
\title{Apply Functions Over `dust_list` Objects}
\usage{
pixieply(X, FUN, ...)

pixiemap(X, FUN, ..., MoreArgs = NULL, SIMPLIFY = FALSE, USE.NAMES = TRUE)
}
\arguments{
\item{X}{An object of class \code{dust_list}.}

\item{FUN}{A function to apply to each element of \code{X}}

\item{...}{Additional arguments to pass to \code{FUN}}

\item{MoreArgs}{a list of other arguments to FUN}

\item{SIMPLIFY}{logical or character string; attempt to reduce the result 
to a vector, matrix or higher dimensional array; see the \code{simplify} 
argument of \code{\link{sapply}}}

\item{USE.NAMES}{logical; use names if the first ... argument has names, 
or if it is a character vector, use that character vector as the names.}
}
\description{
The \code{sprinkle} methods work with \code{dust_list} 
  objects very naturally, but medleys pose a slightly more difficult problem.
  Medleys are intended to be predefined collections of sprinkles that reduce
  the time required to format a table with a particular look and style.  
  It seems counter-productive to expect a user to define each of her or his
  medleys as a method that can work with both \code{dust} and \code{dust_list}
  objects.  \code{pixieply} is a wrapper to \code{lapply} that preserves the
  \code{dust_list} class of the object.
  
  \code{pixiemap} provides functionality to apply differing sprinkles over
  each element of a \code{dust_list}.  The most common example is probably
  adding a unique caption to each table.
}
\examples{
\dontrun{
#* This example will only display the last table 
#* in the viewer pane.  To see the full output,
#* run this example in an Rmarkdown document.
x <- split(mtcars, list(mtcars$am, mtcars$vs))
dust(x) \%>\%
  sprinkle_print_method("html") \%>\%
  pixieply(medley_bw)
}

\dontrun{
#* This is the full text of an RMarkdown script 
#* for the previous example.
---
title: "Pixieply"
output: html_document
---

```{r}
library(pixiedust)
x <- dplyr::group_by(mtcars, am, vs)
dust(x, ungroup = FALSE) \%>\%
  sprinkle_print_method("html") \%>\%
    pixieply(medley_bw)
```
}

}

