% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-async.R
\name{async_reflect}
\alias{async_reflect}
\title{Make an asynchronous function that always succeeds}
\usage{
async_reflect(task)
}
\arguments{
\item{task}{Function to transform.}
}
\value{
Async function returning a deferred value that is never
rejected. Instead its value is a list with entries \code{error} and
\code{result}. If the original deferred was resolved, then \code{error} is
\code{NULL}. If the original deferred was rejected, then \code{result} is
\code{NULL}.
}
\description{
This is sometimes useful, if the function is applied to entries in
a vector or list.
}
\examples{
 badfun <- async(function() stop("oh no!"))
 safefun <- async_reflect(badfun)
 synchronise(when_all(safefun(), "good"))
}
\seealso{
Other async control flow: \code{\link{async_retryable}},
  \code{\link{async_retry}}, \code{\link{async_sequence}},
  \code{\link{async_try_each}}, \code{\link{async_until}},
  \code{\link{async_whilst}}
}
\concept{async control flow}
