% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/internal_field.r
\name{lfief}
\alias{field_profile}
\alias{lfief}
\title{lfief}
\usage{
lfief(wavelength = 500, angle = 0, polarisation = "p", thickness = c(0,
  20, 140, 20, 0), dmax = 200, res = 1000, res2 = res/10,
  epsilon = list(1^2, -12, 1.38^2, -12, 1.46^2), displacement = FALSE, ...)
}
\arguments{
\item{wavelength}{wavelength}

\item{angle}{angle}

\item{polarisation}{polarisation}

\item{thickness}{vector of layer thickness}

\item{dmax}{maximum distance to interface, if > layer thickness}

\item{res}{resolution of sampling points}

\item{res2}{resolution of sampling points outside stack}

\item{epsilon}{list of permittivities}

\item{displacement}{logical, Mperp corresponds to displacement squared (D=epsilon x E)}

\item{...}{further args passed to multilayer}
}
\value{
long format data.frame with positions and LFEF (para and perp)
}
\description{
Local field intensity enhancement factors in a multilayer
}
\details{
returns the LFIEFs as a function of distance inside and outside of the structure
}
\author{
baptiste Auguie
}
\references{
Principles of surface-enhanced Raman spectroscopy and related plasmonic effects

Eric C. Le Ru and Pablo G. Etchegoin, published by Elsevier, Amsterdam (2009).
}
\seealso{
Other helping_functions: \code{\link{classify}};
  \code{\link{internal_field}}; \code{\link{invert_stack}};
  \code{\link{modify_levels}}
}

