% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acisummary.R
\name{acisummary}
\alias{acisummary}
\title{Extracts coefficients from fitacis2}
\usage{
acisummary(data, group1, group2 = NA, group3 = NA, fits)
}
\arguments{
\item{data}{data frame with A/Ci curve data}

\item{group1}{grouping variable 1, must match fitacis2}

\item{group2}{grouping variable 2, must match fitacis2}

\item{group3}{grouping variable 3, must match fitacis2}

\item{fits}{list output from fitacis2}
}
\value{
acisummary produces a data frame with A-Ci coefficients. If the
input data have failed curve fits, these need to be removed before running
acisummary().
}
\description{
Extracts coefficients from fitacis2
}
\examples{
\donttest{
#Read in data
data <- read.csv(system.file("extdata", "example_2.csv",
package = "plantecowrap"), stringsAsFactors = FALSE)
#Run ACi curve fitting
fits <- fitacis2(data, group1 = "Grouping",
varnames = list(ALEAF = "A",
                Tleaf = "Tleaf",
                Ci = "Ci",
                PPFD = "PPFD",
                Rd = "Rd",
                Press = "Press"),
fitmethod = "bilinear", fitTPU = TRUE, Tcorrect = FALSE)
#Extract coefficients
outputs <- acisummary(data, group1 = "Grouping", fits = fits)
}

}
