% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plasso.R
\name{plasso}
\alias{plasso}
\title{Lasso and Post-Lasso}
\usage{
plasso(x, y, w = NULL, ...)
}
\arguments{
\item{x}{Matrix of covariates (number of observations times number of covariates matrix)}

\item{y}{Vector of outcomes}

\item{w}{Vector of weights}

\item{...}{Pass \code{\link[glmnet]{glmnet}} options}
}
\value{
List including base \code{\link[glmnet]{glmnet}} (i.e. Lasso) object and Post-Lasso coefficients.
\item{call}{the call that produced this}
\item{lasso_full}{base \code{\link[glmnet]{glmnet}} object}
\item{beta_plasso}{matrix of coefficients for Post-Lasso model stored in sparse column format}
\item{x}{Input matrix of covariates}
\item{y}{Matrix of outcomes}
\item{w}{Matrix of weights}
}
\description{
\code{\link{plasso}} implicitly estimates a Lasso model using the \code{\link[glmnet]{glmnet}} package
and additionally estimates coefficient paths for a subsequent Post-Lasso model.
}
\examples{
# load toeplitz data
data(toeplitz)
# extract target and features from data
y = as.matrix(toeplitz[,1])
X = toeplitz[,-1]
# fit plasso to the data
\donttest{p = plasso::plasso(X,y)}
# plot coefficient paths for Post-Lasso model
\donttest{plot(p, lasso=FALSE, xvar="lambda")}
# plot coefficient paths for Lasso model
\donttest{plot(p, lasso=TRUE, xvar="lambda")}
# get coefficients for specific lambda approximation
\donttest{coef(p, s=0.05)}
# predict fitted values along whole lambda sequence 
\donttest{pred = predict(p)}
\donttest{head(pred$plasso)}

}
