% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_plate.R
\name{add_plate}
\alias{add_plate}
\title{Read a plater-formatted file and combine it with an existing data frame.}
\usage{
add_plate(data, file, well_ids_column)
}
\arguments{
\item{data}{The data frame to merge the file into. Must contain a column with
well names.}

\item{file}{The path of a .csv file formatted as described in 
\code{\link{read_plate}}.}

\item{well_ids_column}{The name of the column in \code{data} containing the 
well IDs.}
}
\value{
Returns data with as many new columns as plates in \code{file}. 
Empty wells are indicated with NA.
}
\description{
Converts data from \code{plater} format to a data frame with one well 
per row and merges it into an existing data frame by well name.
}
\details{
If data contains more wells than in \code{file}, NA will be added to the 
merged column for those wells. If the file contains more wells than 
\code{data}, an error will result.
}
\examples{
# Part of the data is tidy
file <- system.file("extdata", "example-2-part-A.csv", package = "plater")
data <- read.csv(file)

# Part of the data is plate-shaped
plate_shaped <- system.file("extdata", "example-2-part-B.csv", package = "plater")

# Combine the two
data <- add_plate(
   data = data, 
   file = plate_shaped,
   well_ids_column = "Wells")

# Now data are tidy
head(data)
}

