% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{predict.pliable}
\alias{predict.pliable}
\title{Compute predicted values from a fitted pliable  object
Make predictions from a fitted pliable lasso model}
\usage{
\method{predict}{pliable}(object, x, z, type = c("link", "response",
  "coefficients"), lambda = NULL, verbose = FALSE, ...)
}
\arguments{
\item{object}{object returned from a call to pliable}

\item{x}{n by p matrix of predictors}

\item{z}{n by nz matrix of modifying variables. These may be observed or the predictions from a supervised learning
algorithm that predicts z from test features x  and possibly other features. See example below}

\item{type}{Returns either the fitted values with type="link" or  "response"  or the parameter estimates when type="coefficients" . Type "link" gives the linear
predictors for binomial,  or
cox models; for gaussian models it gives the fitted
values. Type "response" gives the fitted probabilities for
binomial,
and the fitted relative-risk for cox; for gaussian
type "response" is equivalent to type "link".}

\item{lambda}{values of lambda at whcih predictions are desired. If NULL (default), the path of lambda values from the fitted model.
are used. If lambda is  not NULL,  the predictions are made at the closest values to lambda in the lambda path  from  the fitted model;}

\item{verbose}{Should information should be printed along the way?  Default FALSE.}

\item{...}{Further arguments (not used)
@return  predicted values}
}
\description{
Compute predicted values from a fitted pliable  object
Make predictions from a fitted pliable lasso model
}
\examples{
# Train a pliable lasso model
n = 20; p = 3 ;nz=3
x = matrix(rnorm(n*p), n, p)
z =matrix(rnorm(n*nz),n,nz)
y = x[,1] +x[,1]*z[,3]+ rnorm(n)
  fit = pliable(x,z,y)
 # plot coefficient profiles, indicating z-interactions with a "x" symbol
plot(fit)


# Predict using the fitted model
ntest=500
xtest = matrix(rnorm(ntest*p),ntest,p)
ztest =matrix(rnorm(ntest*nz),ntest,nz)

pred= predict(fit,xtest,ztest)

 #Example where z is not observed in the test set,  but predicted from a  supervised
  #  learning method

 library(glmnet)
n = 20; p = 3 ;nz=3
x = matrix(rnorm(n*p), n, p)
z =matrix(rnorm(n*nz),n,nz)
y = x[,1] +x[,1]*z[,3]+ rnorm(n)
fit = pliable(x,z,y)
# predict z  from x; here we use glmnet, but any other supervised learning method
# could be used
zfit=glmnet(x,z,family="mgaussian")

# Predict using the fitted model
ntest=500
xtest = matrix(rnorm(ntest*p),ntest,p)
ztest =predict(zfit,xtest,s=zfit$lambda.min)[,,20]

pred= predict(fit,xtest,ztest)

}
