% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{palettes}
\alias{palettes}
\alias{image_palette}
\title{Create image palettes}
\usage{
image_palette(
  img,
  pattern = NULL,
  npal = 5,
  proportional = TRUE,
  colorspace = c("rgb", "hsb"),
  remove_bg = FALSE,
  index = "B",
  plot = TRUE,
  save_image = FALSE,
  prefix = "proc_",
  dir_original = NULL,
  dir_processed = NULL,
  return_pal = FALSE,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE
)
}
\arguments{
\item{img}{An image object.}

\item{pattern}{A pattern of file name used to identify images to be imported.
For example, if \code{pattern = "im"} all images in the current working directory
that the name matches the pattern (e.g., img1.-, image1.-, im2.-) will be
imported as a list. Providing any number as pattern (e.g., \code{pattern = "1"})
will select images that are named as 1.-, 2.-, and so on. An error will be
returned if the pattern matches any file that is not supported (e.g.,
img1.pdf).}

\item{npal}{The number of color palettes.}

\item{proportional}{Creates a joint palette with proportional size equal to
the number of pixels in the image? Defaults to \code{TRUE}.}

\item{colorspace}{The color space to produce the clusters. Defaults to \code{rgb}.
If \code{hsb}, the color space is first converted from RGB > HSB before k-means
algorithm be applied.}

\item{remove_bg}{Remove background from the color palette? Defaults to
\code{FALSE}.}

\item{index}{An image index used to remove the background, passed to
\code{\link[=image_binary]{image_binary()}}.}

\item{plot}{Plot the generated palette? Defaults to \code{TRUE}.}

\item{save_image}{Save the image after processing? The image is saved in the
current working directory named as \verb{proc_*} where \code{*} is the image name
given in \code{img}.}

\item{prefix}{The prefix to be included in the processed images. Defaults to
\code{"proc_"}.}

\item{dir_original, dir_processed}{The directory containing the original and
processed images. Defaults to \code{NULL}. In this case, the function will search
for the image \code{img} in the current working directory. After processing, when
\code{save_image = TRUE}, the processed image will be also saved in such a
directory. It can be either a full path, e.g., \code{"C:/Desktop/imgs"}, or a
subfolder within the current working directory, e.g., \code{"/imgs"}.}

\item{return_pal}{Return the color palette image? Defaults to \code{FALSE}.}

\item{parallel}{If TRUE processes the images asynchronously (in parallel) in
separate R sessions running in the background on the same machine.}

\item{workers}{A positive numeric scalar or a function specifying the number
of parallel processes that can be active at the same time. By default, the
number of sections is set up to 30\% of available cores.}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}
}
\value{
\code{image_palette()} returns a list with two elements:
\itemize{
\item \code{palette_list} A list with \code{npal} color palettes of class \code{Image}.
\item \code{joint} An object of class \code{Image} with the color palettes
\item \code{proportions} The proportion of the entire image corresponding to each color in the palette
\item \code{rgbs} The average RGB value for each palette
}
}
\description{
\code{image_palette()}  creates image palettes by applying the k-means algorithm
to the RGB values.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
img <- image_pliman("sev_leaf.jpg")
pal <- image_palette(img, npal = 5)
}


}
