% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_cce.R
\name{pcce}
\alias{pcce}
\alias{summary.pcce}
\alias{print.summary.pcce}
\alias{residuals.pcce}
\alias{model.matrix.pcce}
\alias{pmodel.response.pcce}
\title{Common Correlated Effects estimators}
\usage{
pcce(
  formula,
  data,
  subset,
  na.action,
  model = c("mg", "p"),
  index = NULL,
  trend = FALSE,
  ...
)

\method{summary}{pcce}(object, vcov = NULL, ...)

\method{print}{summary.pcce}(
  x,
  digits = max(3, getOption("digits") - 2),
  width = getOption("width"),
  ...
)

\method{residuals}{pcce}(object, type = c("defactored", "standard"), ...)

\method{model.matrix}{pcce}(object, ...)

\method{pmodel.response}{pcce}(object, ...)
}
\arguments{
\item{formula}{a symbolic description of the model to be estimated,}

\item{data}{a \code{data.frame},}

\item{subset}{see \code{lm},}

\item{na.action}{see \code{lm},}

\item{model}{one of \code{"mg"}, \code{"p"}, selects Mean Groups vs. Pooled
CCE model,}

\item{index}{the indexes, see \code{\link[=pdata.frame]{pdata.frame()}},}

\item{trend}{logical specifying whether an individual-specific
trend has to be included,}

\item{\dots}{further arguments.}

\item{object, x}{an object of class \code{"pcce"},}

\item{vcov}{a variance-covariance matrix furnished by the user or a function to calculate one,}

\item{digits}{digits,}

\item{width}{the maximum length of the lines in the print output,}

\item{type}{one of \code{"defactored"} or \code{"standard"},}
}
\value{
An object of class \code{c("pcce", "panelmodel")} containing:
\item{coefficients}{the vector of coefficients,}
\item{residuals}{the vector of (defactored) residuals,}
\item{stdres}{the vector of (raw) residuals,}
\item{tr.model}{the transformed data after projection on H,}
\item{fitted.values}{the vector of fitted values,}
\item{vcov}{the covariance matrix of the coefficients,}
\item{df.residual}{degrees of freedom of the residuals,}
\item{model}{a data.frame containing the variables used for the
estimation,}
\item{call}{the call,}
\item{indcoef}{the matrix of individual coefficients from
separate time series regressions,}
\item{r.squared}{numeric, the R squared.}
}
\description{
Common Correlated Effects Mean Groups (CCEMG) and Pooled (CCEP)
estimators for panel data with common factors (balanced or
unbalanced)
}
\details{
\code{pcce} is a function for the estimation of linear panel models by
the Common Correlated Effects Mean Groups or Pooled estimator,
consistent under the hypothesis of unobserved common factors and
idiosyncratic factor loadings. The CCE estimator works by
augmenting the model by cross-sectional averages of the dependent
variable and regressors in order to account for the common factors,
and adding individual intercepts and possibly trends.
}
\examples{

data("Produc", package = "plm")
ccepmod <- pcce(log(gsp) ~ log(pcap) + log(pc) + log(emp) + unemp, data = Produc, model="p")
## IGNORE_RDIFF_BEGIN
summary(ccepmod)
summary(ccepmod, vcov = vcovHC) # use argument vcov for robust std. errors
## IGNORE_RDIFF_END

ccemgmod <- pcce(log(gsp) ~ log(pcap) + log(pc) + log(emp) + unemp, data = Produc, model="mg")
## IGNORE_RDIFF_BEGIN
summary(ccemgmod)
## IGNORE_RDIFF_END

}
\references{
\insertRef{kappesyam11}{plm}
}
\author{
Giovanni Millo
}
\keyword{regression}
