% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss-plmm.R
\name{plmm_loss}
\alias{plmm_loss}
\title{Loss method for "plmm" class}
\usage{
plmm_loss(y, yhat)
}
\arguments{
\item{y}{Observed outcomes (response) vector}

\item{yhat}{Predicted outcomes (response) vector}
}
\value{
A numeric vector of the squared-error loss values for the given
observed and predicted outcomes
}
\description{
Loss method for "plmm" class
}
\examples{
admix_design <- create_design(X = admix$X, outcome_col = admix$y)
fit <- plmm(design = admix_design, K = relatedness_mat(admix$X))
yhat <- predict(object = fit, newX = admix$X, type = 'lp', lambda = 0.05)
head(plmm_loss(yhat = yhat, y = admix$y))

}
