% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtern.R
\name{stat_3logit}
\alias{stat_3logit}
\title{Add a field to a \code{gg3logit} plot}
\usage{
stat_3logit(mapping = aes(), data = NULL, geom = "segment",
  position = "identity", show.legend = NA, inherit.aes = TRUE,
  arrow. = arrow(length = unit(0.2, "cm")), ...)
}
\arguments{
\item{mapping}{list of aesthetic mappings to use for plot. \strong{Note
that} mappings \code{x}, \code{y} and \code{z} are \strong{not} required: they will be
overwritten if specified (see examples).}

\item{data}{a \code{field3logit} or a \code{multifield3logit} object.}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{arrow.}{specification for arrow heads, as created by
function \code{\link[grid:arrow]{arrow}} of package \code{\link[grid:grid-package]{grid}}.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
\code{stat_3logit} add a field to a \code{\link{gg3logit}} plot.
}
\examples{
data(cross_1year)

mod0 <- nnet::multinom(employment_sit ~ gender + finalgrade, data = cross_1year)
field0 <- field3logit(mod0, 'genderFemale')

gg3logit(field0) + stat_3logit()
gg3logit() + stat_3logit(data = field0)

}
\seealso{
Other `gg` functions: \code{\link{gg3logit}},
  \code{\link{multifield3logit}}
}
\concept{`gg` functions}
