% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_GMM.R
\name{plot_GMM}
\alias{plot_GMM}
\title{Plots Mixture Components from Gaussian Mixture Models}
\usage{
plot_GMM(m, k=NULL)
}
\arguments{
\item{m}{An object of class \code{mixEM} corresponding with the fit GMM}

\item{k}{The number of components specified in the GMM, \code{m}}
}
\description{
Generates a plot of data densities with overlaid mixture components from a Gaussian mixture model (GMM)
}
\details{
Uses ggplot2 graphics to plot data densities with overlaid components from \code{mixEM} objects, which are GMM's fit using the \code{mixtools} package.

Note: Users must enter the same component value, \code{k}, in the \code{plot_GMM} function, as that which was specified in the original GMM specification (also \code{k} in \code{mixtools}).
}
\examples{
set.seed(235)
mixmdl <- mixtools::normalmixEM(faithful$waiting, k = 2)

plot_GMM(mixmdl, 2)
}
\references{
Benaglia, T., Chauveau, D., Hunter, D. and Young, D., 2009. mixtools: An R package for analyzing finite mixture models. Journal of Statistical Software, 32(6), pp.1-29.

Wickham, H., 2016. ggplot2: elegant graphics for data analysis. Springer.
}
