# Purpose        : Generate standard metadata fields;
# Maintainer     : Tomislav Hengl (tom.hengl@wur.nl)
# Contributions  : Michael Blaschek (blaschek@geographie.uni-kiel.de) and Eloi Ribeiro (eloi.carvalhoribeiro@wur.nl);
# Dev Status     : Pre-Alpha
# Note           : Human-readable field names suggested by the authors;

metadata <- new.env(hash=TRUE, parent = parent.frame())

metadata.env <- function(
   ## INSPIRE:
   UUID = "",
   Language_code = "eng",
   MD_Character_set_code = "eng",
   MD_scope_code = "dataset",
   CI_Organisation_name = paste(Sys.getenv(c("USERDNSDOMAIN"))[[1]], "(domain)"),
   CI_Electronic_mail_address = "",
   CI_Role = "pointOfContact",
   Date_stamp = Sys.Date(),
   MD_Standard_name = "ISO 19115",
   MD_Standard_version = "2003/Cor.1:2006",
   CI_Citation_title = "",
   CI_Citation_date = Sys.Date(),
   CI_Citation_date_type = "publication",
   CI_Unique_name = "",
   CI_RS_identifier = "",
   MD_Abstract = "",
   MD_Organisation_name = paste(Sys.getenv(c("COMPUTERNAME"))[[1]], "(computer name) at", Sys.getenv(c("USERDNSDOMAIN"))[[1]], "(domain)"),
   MD_Electronic_mail_address = "",
   MD_Role = "author",
   MD_Keyword = "",
   MD_Thesaurus_name = "GEMET - INSPIRE themes, version 1.0",
   MD_Thesaurus_date = as.Date("2008-03-16", format="%Y-%m-%d"),
   MD_Thesaurus_date_type = "publication",
   MD_Use_limitations = "",
   MD_Access_constraints = "otherRestrictions",
   MD_Other_restrictions = get("license_url", envir = plotKML.opts),
   MD_Equivalent_scale = "",
   MD_Resolution = "",
   MD_Language_code = Language_code,
   MD_Topic_category_code = "geoscientificInformation",
   Extent_West_Longitude = "",
   Extent_East_Longitude = "",
   Extent_South_Latitude = "",
   Extent_North_Latitude = "",
   Time_period_begin = "",
   Time_period_end = "",
   CI_Online_resource_URL = "",
   DQ_Scope_code = "",
   DQ_Citation_title = "Commission Regulation (EU) No 1089/2010 of 23 November 2010 implementing Directive 2007/2/EC of the European Parliament and of the Council as regards interoperability of spatial data sets and services",
   DQ_Citation_date = "2010-12-08",
   DQ_Citation_date_type = "publication",
   DQ_Conformance_result = "",
   DQ_Conformance_result_pass = "",
   DQ_Lineage_statement = "",
    ## FGDC:
    Attribute_accuracy_report = '',
    Completeness_Report = '',
    Process_Date = Sys.Date(),
    Process_Description = '',
    Online_Linkage = '',
    Data_Quality_Citation_Originator = '',
    Data_Quality_Publication_Date = '',
    Data_Quality_Citation_Title = '',
    Data_Quality_Citation_Abbreviation = '',
    Data_Quality_Contribution = '',
    Source_Scale_Denominator = '',
    Source_Currentness_Reference = '',
    Source_Date_of_Content = '',
    Type_of_Source_Media = "online",
    Logical_Consistency_Report = '',
    Horizontal_accuracy_report = '',
    Vertical_accuracy_report = '',
    Distribution_Liability = get("license_url", envir = plotKML.opts),
    Distributor_address = '',
    Distributor_address_type = '',
    Distributor_city = '',
    Distributor_country = '',
    Distributior_postal = '',
    Distributor_state = '',
    Data_Distributing_Organization = '',
    Distributor_Name = '',
    Distributor_Telephone = '',
    Resource_Description = '',
    File_Decompression_Technique = '',
    Format_Information_Content = '',
    Format_Name = '',
    Format_Version_Number = '',
    Transfer_Size = '',
    Access_Instructions = '',
    Data_Order_URL = '',
    Online_Computer = '',
    Order_fees = '',
    Attribute_Definition = '',
    Attribute_Definition_Source = '',
    Attribute_Measurement_Resolution = '',
    Attribute_Units_of_Measure = '',
    Range_Domain_Maximum = '',
    Range_Domain_Minimum = '',
    Attribute_Label = '',
    Attribute_Measurement_Frequency = '',
    Attribute_Value_Accuracy = '',
    Attribute_Value_Accuracy_Explanation = '',
    Beginning_Date_of_Attribute_Values = '',
    Ending_Date_of_Attribute_Values = '',
    Entity_Type_Definition = '',
    Entity_Type_Definition_Source = '',
    Entity_Type_Label = '',
    Entity_and_Attribute_Detail_Citation = '',
    Entity_and_Attribute_Overview = '',
    Access_Constraints = '',
    Browse_Graphic_File_Description = '',
    Browse_Graphic_File_Name = '',
    Browse_Graphic_File_Type = '',
    Geospatial_Data_Presentation_Form = "map",
    Citation_URL = '',
    Citation_Originator = paste(Sys.getenv(c("COMPUTERNAME"))[[1]], "(computer name) at", Sys.getenv(c("USERDNSDOMAIN"))[[1]], "(domain)"),
    Other_Citation_Details = '',
    Publication_Date = '',
    Citation_Publisher = '',
    Publication_Place = '',
    Citation_title = '',
    Data_Set_Credit = Citation_Originator,
    Abstract = '',
    Purpose = '',
    Supplemental_Information = '',
    Theme_Keyword = '',
    Theme_Keyword_Thesaurus = '',
    Native_Data_Set_Environment = paste(R.version$version.string, "running on", Sys.info()[["sysname"]], Sys.info()[["release"]]),
    Contact_Information_Address = '',
    Contact_Address_Type = '',
    Contact_Information_City = '',
    Contact_Information_Country = '',
    Contact_Information_Postal = '',
    Contact_Information_State = '',
    Contact_Information_Organization = '',
    Contact_Information_Person = paste(Sys.getenv(c("COMPUTERNAME"))[[1]], "(computer name) at", Sys.getenv(c("USERDNSDOMAIN"))[[1]], "(domain)"),
    Contact_Information_Telephone = '',
    East_Bounding_Coordinate = '',
    North_Bounding_Coordinate = '',
    South_Bounding_Coordinate = '',
    West_Bounding_Coordinate = '',
    Status_Progress = "In work",
    Maintenance_and_Update_Frequency = "Unknown",
    Currentness_Reference = '',
    Beginning_Date = '',
    Ending_Date = '',
    Use_Constraints = get("license_url", envir = plotKML.opts),
    Metadata_Access_Constraints = '',
    Metadata_Contact_Address = '',
    Metadata_Contact_Address_Type = '',
    Metadata_Contact_City = '',
    Metadata_Contact_Country = '',
    Metadata_Contact_Postal = '',
    Metadata_Contact_State = '',
    Metadata_Contact_Organization = '',
    Metadata_Contact_Position = '',
    Metadata_Contact_Telephone = '',
    Metadata_Date = Sys.Date(),
    Metadata_Classification = '',
    Metadata_Security_Classification_System = '',
    Metadata_Restrictions = '',
    Metadata_Standard_Name = "FGDC-STD-001-1998",
    Metadata_Standard_Version = '',
    Metadata_Use_Constraints = '',
    Direct_Spatial_Reference_Method = '',
    Indirect_Spatial_Reference = '',
    Object_Count = '',
    SDTS_Point_and_Vector_Object_Type = '',
    Denominator_of_Flattening_Ratio = '',
    Ellipsoid_Name = '',
    Horizontal_Datum_Name = '',
    Semi_major_Axis = '',
    Geographic_Coordinate_Units = '',
    Latitude_Resolution = '',
    Longitude_Resolution = '',
    show.env = FALSE,
    ...
   )
   {

   md.lst <- list(
    ## INSPIRE:
    UUID = UUID,
    Language_code = Language_code,
    MD_Character_set_code = MD_Character_set_code,
    MD_scope_code = MD_scope_code,
    CI_Organisation_name = CI_Organisation_name,
    CI_Electronic_mail_address = CI_Electronic_mail_address,
    CI_Role = CI_Role,
    Date_stamp = Date_stamp,
    MD_Standard_name = MD_Standard_name,
    MD_Standard_version = MD_Standard_version,
    CI_Citation_title = CI_Citation_title,
    CI_Citation_date = CI_Citation_date,
    CI_Citation_date_type = CI_Citation_date_type,
    CI_Unique_name = CI_Unique_name,
    CI_RS_identifier = CI_RS_identifier,
    MD_Abstract = MD_Abstract,
    MD_Organisation_name = MD_Organisation_name,
    MD_Electronic_mail_address = MD_Electronic_mail_address,
    MD_Role = MD_Role,
    MD_Keyword = MD_Keyword,
    MD_Thesaurus_name = MD_Thesaurus_name,
    MD_Thesaurus_date = MD_Thesaurus_date,
    MD_Thesaurus_date_type = MD_Thesaurus_date_type,
    MD_Use_limitations = MD_Use_limitations,
    MD_Access_constraints = MD_Access_constraints,
    MD_Other_restrictions = MD_Other_restrictions,
    MD_Equivalent_scale = MD_Equivalent_scale,
    MD_Resolution = MD_Resolution,
    MD_Language_code = MD_Language_code,
    MD_Topic_category_code = MD_Topic_category_code,
    Extent_West_Longitude = Extent_West_Longitude,
    Extent_East_Longitude = Extent_East_Longitude,
    Extent_South_Latitude = Extent_South_Latitude,
    Extent_North_Latitude = Extent_North_Latitude,
    Time_period_begin = Time_period_begin,
    Time_period_end = Time_period_end,
    CI_Online_resource_URL = CI_Online_resource_URL,
    DQ_Scope_code = DQ_Scope_code,
    DQ_Citation_title = DQ_Citation_title,
    DQ_Citation_date = DQ_Citation_date,
    DQ_Citation_date_type = DQ_Citation_date_type,
    DQ_Conformance_result = DQ_Conformance_result,
    DQ_Conformance_result_pass = DQ_Conformance_result_pass,
    DQ_Lineage_statement = DQ_Lineage_statement,
    ##FGDC
    Attribute_accuracy_report = Attribute_accuracy_report,
    Completeness_Report = Completeness_Report,
    Process_Date = Process_Date,
    Process_Description = Process_Description,
    Online_Linkage = Online_Linkage,
    Data_Quality_Citation_Originator = Data_Quality_Citation_Originator,
    Data_Quality_Publication_Date = Data_Quality_Publication_Date,
    Data_Quality_Citation_Title = Data_Quality_Citation_Title,
    Data_Quality_Citation_Abbreviation = Data_Quality_Citation_Abbreviation,
    Data_Quality_Contribution = Data_Quality_Contribution,
    Source_Scale_Denominator = Source_Scale_Denominator,
    Source_Currentness_Reference = Source_Currentness_Reference,
    Source_Date_of_Content = Source_Date_of_Content,
    Type_of_Source_Media = Type_of_Source_Media,
    Logical_Consistency_Report = Logical_Consistency_Report,
    Horizontal_accuracy_report = Horizontal_accuracy_report,
    Vertical_accuracy_report = Vertical_accuracy_report,
    Distribution_Liability = Distribution_Liability,
    Distributor_address = Distributor_address,
    Distributor_address_type = Distributor_address_type,
    Distributor_city = Distributor_city,
    Distributor_country = Distributor_country,
    Distributior_postal = Distributior_postal,
    Distributor_state = Distributor_state,
    Data_Distributing_Organization = Data_Distributing_Organization,
    Distributor_Name = Distributor_Name,
    Distributor_Telephone = Distributor_Telephone,
    Resource_Description = Resource_Description,
    File_Decompression_Technique = File_Decompression_Technique,
    Format_Information_Content = Format_Information_Content,
    Format_Name = Format_Name,
    Format_Version_Number = Format_Version_Number,
    Transfer_Size = Transfer_Size,
    Access_Instructions = Access_Instructions,
    Data_Order_URL = Data_Order_URL,
    Online_Computer = Online_Computer,
    Order_fees = Order_fees,
    Attribute_Definition = Attribute_Definition,
    Attribute_Definition_Source = Attribute_Definition_Source,
    Attribute_Measurement_Resolution = Attribute_Measurement_Resolution,
    Attribute_Units_of_Measure = Attribute_Units_of_Measure,
    Range_Domain_Maximum = Range_Domain_Maximum,
    Range_Domain_Minimum = Range_Domain_Minimum,
    Attribute_Label = Attribute_Label,
    Attribute_Measurement_Frequency = Attribute_Measurement_Frequency,
    Attribute_Value_Accuracy = Attribute_Value_Accuracy,
    Attribute_Value_Accuracy_Explanation = Attribute_Value_Accuracy_Explanation,
    Beginning_Date_of_Attribute_Values = Beginning_Date_of_Attribute_Values,
    Ending_Date_of_Attribute_Values = Ending_Date_of_Attribute_Values,
    Entity_Type_Definition = Entity_Type_Definition,
    Entity_Type_Definition_Source = Entity_Type_Definition_Source,
    Entity_Type_Label = Entity_Type_Label,
    Entity_and_Attribute_Detail_Citation = Entity_and_Attribute_Detail_Citation,
    Entity_and_Attribute_Overview = Entity_and_Attribute_Overview,
    Access_Constraints = Access_Constraints,
    Browse_Graphic_File_Description = Browse_Graphic_File_Description,
    Browse_Graphic_File_Name = Browse_Graphic_File_Name,
    Browse_Graphic_File_Type = Browse_Graphic_File_Type,
    Geospatial_Data_Presentation_Form = Geospatial_Data_Presentation_Form,
    Citation_URL = Citation_URL,
    Citation_Originator = Citation_Originator,
    Other_Citation_Details = Other_Citation_Details,
    Publication_Date = Publication_Date,
    Citation_Publisher = Citation_Publisher,
    Publication_Place = Publication_Place,
    Citation_title = Citation_title,
    Data_Set_Credit = Data_Set_Credit,
    Abstract = Abstract,
    Purpose = Purpose,
    Supplemental_Information = Supplemental_Information,
    Theme_Keyword = Theme_Keyword,
    Theme_Keyword_Thesaurus = Theme_Keyword_Thesaurus,
    Native_Data_Set_Environment = Native_Data_Set_Environment,
    Contact_Information_Address = Contact_Information_Address,
    Contact_Address_Type = Contact_Address_Type,
    Contact_Information_City = Contact_Information_City,
    Contact_Information_Country = Contact_Information_Country,
    Contact_Information_Postal = Contact_Information_Postal,
    Contact_Information_State = Contact_Information_State,
    Contact_Information_Organization = Contact_Information_Organization,
    Contact_Information_Person = Contact_Information_Person,
    Contact_Information_Telephone = Contact_Information_Telephone,
    East_Bounding_Coordinate = East_Bounding_Coordinate,
    North_Bounding_Coordinate = North_Bounding_Coordinate,
    South_Bounding_Coordinate = South_Bounding_Coordinate,
    West_Bounding_Coordinate = West_Bounding_Coordinate,
    Status_Progress = Status_Progress,
    Maintenance_and_Update_Frequency = Maintenance_and_Update_Frequency,
    Currentness_Reference = Currentness_Reference,
    Beginning_Date = Beginning_Date,
    Ending_Date = Ending_Date,
    Use_Constraints = Use_Constraints,
    Metadata_Access_Constraints = Metadata_Access_Constraints,
    Metadata_Contact_Address = Metadata_Contact_Address,
    Metadata_Contact_Address_Type = Metadata_Contact_Address_Type,
    Metadata_Contact_City = Metadata_Contact_City,
    Metadata_Contact_Country = Metadata_Contact_Country,
    Metadata_Contact_Postal = Metadata_Contact_Postal,
    Metadata_Contact_State = Metadata_Contact_State,
    Metadata_Contact_Organization = Metadata_Contact_Organization,
    Metadata_Contact_Position = Metadata_Contact_Position,
    Metadata_Contact_Telephone = Metadata_Contact_Telephone,
    Metadata_Date = Metadata_Date,
    Metadata_Classification = Metadata_Classification,
    Metadata_Security_Classification_System = Metadata_Security_Classification_System,
    Metadata_Restrictions = Metadata_Restrictions,
    Metadata_Standard_Name = Metadata_Standard_Name,
    Metadata_Standard_Version = Metadata_Standard_Version,
    Metadata_Use_Constraints = Metadata_Use_Constraints,
    Direct_Spatial_Reference_Method = Direct_Spatial_Reference_Method,
    Indirect_Spatial_Reference = Indirect_Spatial_Reference,
    Object_Count = Object_Count,
    SDTS_Point_and_Vector_Object_Type = SDTS_Point_and_Vector_Object_Type,
    Denominator_of_Flattening_Ratio = Denominator_of_Flattening_Ratio,
    Ellipsoid_Name = Ellipsoid_Name,
    Horizontal_Datum_Name = Horizontal_Datum_Name,
    Semi_major_Axis = Semi_major_Axis,
    Geographic_Coordinate_Units = Geographic_Coordinate_Units,
    Latitude_Resolution = Latitude_Resolution,
    Longitude_Resolution = Longitude_Resolution
   )
   
   x <- lapply(names(md.lst), function(x){ assign(x, md.lst[[x]], envir=metadata) })
   if(show.env){
     message("Generaring static metadata based on the computer configuration.\nSee '?spMetadata' for more details.")  
     return(metadata)  
   }
}

## end of script;
