% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{getCoords}
\alias{getCoords}
\title{Convert proportions into coordinates of the plot or figure region.}
\usage{
getCoords(pos = 1.1, side = 1, input = "p")
}
\arguments{
\item{pos}{A number indicating the proportion on the x-axis. Default is 1.1.}

\item{side}{Which axis to choose: 1=bottom, 2=left, 3=top, 4=right. Default is 1.}

\item{input}{Which proportion to take: with respect to the plot region 
(input 'p', default), or with respect to figure region (input 'f').}
}
\description{
Function for positioning a legend or label in or outside the 
plot region based on proportion of the plot region rather than Cartesian 
coordinates.
}
\examples{
# set larger plot window, depending on your system:
# dev.new(,with=8, height=4) # windows, mac
# quartz(,8,4)               # Mac
# x11(width=8, height=4)     # linux
par(mfrow=c(1,2))

# PLOT 1: y-range is -1 to 1
emptyPlot(c(0,1),c(-1,1), h0=0, v0=0.5)
# calculate the x-coordinates for points at proportion
# -0.2, 0, .25, .5, 1.0, and 1.1 of the plot window:
p1 <- getCoords(pos=c(-0.2,0,.25,.5,1,1.1), side=2)
# use xpd=TRUE to plot outside plot region:
points(rep(0.5,length(p1)), p1, pch=16, xpd=TRUE)
# add legend outside plot region, in upper-right corner of figure:
legend(x=getCoords(1,side=1, input='f'), y=getCoords(1, side=2, input='f'),
    xjust=1, yjust=1,
    legend=c("points"), pch=16, xpd=TRUE)
# Note: this can easier be achieved with function getFigCoords

# PLOT 2: y-range is 25 to 37
# we would like to plot the points and legend at same positions
emptyPlot(c(0,1),c(25,37), h0=0, v0=0.5)
p1 <- getCoords(pos=c(-0.2,0,.25,.5,1,1.1), side=2)
points(rep(0.5,length(p1)), p1, pch=16, xpd=TRUE)
# add legend outside plot region, in upper-left corner of figure:
legend(x=getCoords(0,side=1, input='f'), y=getCoords(1, side=2, input='f'),
    xjust=0, yjust=1,
    legend=c("points"), pch=16, xpd=TRUE)

}
\author{
Jacolien van Rij
}
\seealso{
\code{\link{getFigCoords}}, \code{\link{getProps}}

Other Functions for plotting: \code{\link{addInterval}},
  \code{\link{add_bars}}, \code{\link{add_n_points}},
  \code{\link{alphaPalette}}, \code{\link{alpha}},
  \code{\link{check_normaldist}},
  \code{\link{color_contour}}, \code{\link{dotplot_error}},
  \code{\link{drawArrows}}, \code{\link{emptyPlot}},
  \code{\link{errorBars}}, \code{\link{fill_area}},
  \code{\link{getFigCoords}}, \code{\link{getProps}},
  \code{\link{gradientLegend}},
  \code{\link{legend_margin}},
  \code{\link{marginDensityPlot}},
  \code{\link{plot_error}}, \code{\link{plot_image}},
  \code{\link{plotsurface}}
}

