% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sankeyplot.R
\name{SankeyPlot}
\alias{SankeyPlot}
\alias{AlluvialPlot}
\title{Sankey / Alluvial Plot}
\usage{
SankeyPlot(
  data,
  y = NULL,
  nodes_by,
  nodes_color = "grey30",
  links_by = NULL,
  links_by_sep = "_",
  links_name = NULL,
  split_by = NULL,
  split_by_sep = "_",
  palette = "Paired",
  palcolor = NULL,
  alpha = 0.6,
  nodes_label = FALSE,
  x_text_angle = 0,
  aspect.ratio = 1,
  legend.position = "right",
  legend.direction = "vertical",
  legend.box = "vertical",
  theme = "theme_this",
  theme_args = list(),
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  combine = TRUE,
  nrow = NULL,
  ncol = NULL,
  byrow = TRUE,
  seed = 8525,
  ...
)

AlluvialPlot(
  data,
  y = NULL,
  nodes_by,
  nodes_color = "grey30",
  links_by = NULL,
  links_by_sep = "_",
  links_name = NULL,
  split_by = NULL,
  split_by_sep = "_",
  palette = "Paired",
  palcolor = NULL,
  alpha = 0.6,
  nodes_label = FALSE,
  x_text_angle = 0,
  aspect.ratio = 1,
  legend.position = "right",
  legend.direction = "vertical",
  legend.box = "vertical",
  theme = "theme_this",
  theme_args = list(),
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  combine = TRUE,
  nrow = NULL,
  ncol = NULL,
  byrow = TRUE,
  seed = 8525,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{y}{A character string specifying the column name of the data frame to plot for the y-axis.}

\item{nodes_by}{A character vector of column names to define the nodes.}

\item{nodes_color}{A character string to color the nodes.}

\item{links_by}{A character vector of column names to define the links.
If NULL, the links_by will be the first column in nodes_by.}

\item{links_by_sep}{A character string to concatenate the columns in \code{links_by}, if multiple columns are provided.}

\item{links_name}{A character string to name the legend of links.}

\item{split_by}{The column(s) to split data by and plot separately.}

\item{split_by_sep}{The separator for multiple split_by columns. See \code{split_by}}

\item{palette}{A character string specifying the palette to use.
A named list or vector can be used to specify the palettes for different \code{split_by} values.}

\item{palcolor}{A character string specifying the color to use in the palette.
A named list can be used to specify the colors for different \code{split_by} values.
If some values are missing, the values from the palette will be used (palcolor will be NULL for those values).}

\item{alpha}{A numeric value specifying the transparency of the plot.}

\item{nodes_label}{A logical value to show the labels on the nodes.}

\item{x_text_angle}{A numeric value specifying the angle of the x-axis text.}

\item{aspect.ratio}{A numeric value specifying the aspect ratio of the plot.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{legend.box}{A character string to specify the box of the legend, either "vertical" or "horizontal".}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{xlab}{A character string specifying the x-axis label.}

\item{ylab}{A character string specifying the y-axis label.}

\item{combine}{Whether to combine the plots into one when facet is FALSE. Default is TRUE.}

\item{nrow}{A numeric value specifying the number of rows in the facet.}

\item{ncol}{A numeric value specifying the number of columns in the facet.}

\item{byrow}{A logical value indicating whether to fill the plots by row.}

\item{seed}{The random seed to use. Default is 8525.}

\item{...}{Additional arguments.}
}
\value{
A ggplot object or wrap_plots object or a list of ggplot objects
}
\description{
A plot visualizing flow/movement/change from one state to another or one time to another.
\code{AlluvialPlot} is an alias of \code{SankeyPlot}.
}
\examples{
\donttest{
set.seed(8525)
data <- data.frame(
    nodes1 = sample(LETTERS[1:3], 10, replace = TRUE),
    nodes2 = sample(letters[1:3], 10, replace = TRUE),
    nodes3 = sample(LETTERS[4:6], 10, replace = TRUE),
    y = sample(1:5, 10, replace = TRUE)
)
SankeyPlot(data, nodes_by = c("nodes1", "nodes2", "nodes3"))
SankeyPlot(data, nodes_by = c("nodes1", "nodes2", "nodes3"), nodes_label = TRUE)
SankeyPlot(data, nodes_by = c("nodes1", "nodes2", "nodes3"), links_by = "y")
SankeyPlot(data, nodes_by = c("nodes1", "nodes2", "nodes3"), y = "y")
}
}
