% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plsRglm-package.R
\docType{package}
\name{plsRglm-package}
\alias{plsRglm-package}
\title{plsRglm-package}
\description{
Provides (weighted) Partial least squares Regression for generalized linear models and repeated k-fold cross-validation of such models using various criteria <arXiv:1810.01005>. It allows for missing data in the explanatory variables. Bootstrap confidence intervals constructions are also available.
}
\examples{
set.seed(314)
library(plsRglm)
data(Cornell)
cv.modpls<-cv.plsR(Y~.,data=Cornell,nt=6,K=6)
res.cv.modpls<-cvtable(summary(cv.modpls))

}
\references{
A short paper that sums up some of features of the package is available on \url{https://arxiv.org/}, Frédéric Bertrand and Myriam Maumy-Bertrand (2018), "plsRglm: Partial least squares linear and generalized linear regression for processing incomplete datasets by cross-validation and bootstrap techniques with R", *arxiv*, \url{https://arxiv.org/abs/1810.01005}, \url{https://github.com/fbertran/plsRglm/} et \url{https://fbertran.github.io/plsRglm/}
}
