% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{simulate_classes}
\alias{simulate_classes}
\alias{simulate_data}
\title{Simulate classes}
\usage{
simulate_classes(p, n1, n2)

simulate_data(dims, n1 = 150, n2 = 50)
}
\arguments{
\item{p}{integer number of variables.}

\item{n1}{integer number of samples in each of two classes in training/calibration data.}

\item{n2}{integer number of samples in each of two classes in test/validation data.}

\item{dims}{a 10 element vector of group sizes.}
}
\value{
Returns a list of predictor and response data for training and testing.
}
\description{
Simulate multivariate normal data.
}
\details{
The class simulation is a straigh forward simulation of mulitvariate normal
data into two classes for training and test data, respectively.
The data simulation uses a strictly structured multivariate normal simulation for 
with continuous response data.
}
\examples{
str(simulate_classes(5,4,4))

}
\references{
T. Mehmood, K.H. Liland, L. Snipen, S. Sæbø, A review of variable selection 
methods in Partial Least Squares Regression, Chemometrics and Intelligent Laboratory Systems
118 (2012) 62-69.
T. Mehmood, S. Sæbø, K.H. Liland, Comparison of variable selection methods in partial least
squares regression, Journal of Chemometrics 34 (2020) e3226.
}
\seealso{
\code{\link{VIP}} (SR/sMC/LW/RC), \code{\link{filterPLSR}}, \code{\link{shaving}}, 
\code{\link{stpls}}, \code{\link{truncation}},
\code{\link{bve_pls}}, \code{\link{ga_pls}}, \code{\link{ipw_pls}}, \code{\link{mcuve_pls}},
\code{\link{rep_pls}}, \code{\link{spa_pls}},
\code{\link{lda_from_pls}}, \code{\link{lda_from_pls_cv}}, \code{\link{setDA}}.
}
\author{
Tahir Mehmood, Kristian Hovde Liland, Solve Sæbø.
}
