% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btscs.R
\name{btscs}
\alias{btscs}
\title{Generate spells for binary variables}
\source{
This function is a port of Dave Armstrong's \code{btscs} function
from:

Dave Armstrong (2015). DAMisc: Dave Armstrong's Miscellaneous Functions.
R package version 1.3. \url{https://CRAN.R-project.org/package=DAMisc}.

It was ported largely to reduce the dependencies needed for the examples.
There are also internal improvements, largely to handle single period spells
and to start the spell time counter from 1.

David's package implemented the Stata function from:

Beck, N.. J. Katz and R. Tucker. 1998. "Beyond Ordinary Logit: Taking Time
Seriously in Binary-Time-Series-Cross-Section Models". American Journal of
Political Science 42(4): 1260-1288.
}
\usage{
btscs(df, event, t_var, cs_unit, pad_ts = FALSE)
}
\arguments{
\item{df}{a data frame}

\item{event}{character string naming the binary variable identifying the
event. Note \code{1} must signify events and \code{0} non-events.}

\item{t_var}{character string with the name of the time variable.}

\item{cs_unit}{character string with the name of the cross-sectional unit.}

\item{pad_ts}{logical indicating whether or not to fill in the time-series
if panels are unbalanced.}
}
\value{
The original (\code{df}) data frame with an additional
\code{spell_time} value identifying the number of observed periods in the spell,
i.e. time points since the last period.
}
\description{
Generate spells for binary variables
}
\examples{
data('negative')

neg_set <- btscs(df = negative, event = 'y', t_var = 'tim', cs_unit = 'group')

}
