% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plu_stick.R
\name{plu_stick}
\alias{plu_stick}
\alias{stick}
\title{Collapse character vectors into natural language strings}
\usage{
plu_stick(
  x,
  fn = NULL,
  ...,
  max = Inf,
  fn_overflow = FALSE,
  sep = ", ",
  conj = " and ",
  syndeton = c("last", "all", "none"),
  oxford = getOption("plu.oxford_comma")
)

stick(
  x,
  fn = NULL,
  ...,
  max = Inf,
  fn_overflow = FALSE,
  sep = ", ",
  conj = " and ",
  syndeton = c("last", "all", "none"),
  oxford = getOption("plu.oxford_comma")
)
}
\arguments{
\item{x}{A character vector (or a vector coercible to character)}

\item{fn}{A function to apply to all items in the list}

\item{...}{Additional arguments to \code{fn}}

\item{max}{The maximum number of items to list.
Additional arguments are replaced with "{n} more".
Defaults to \code{Inf}, which prints all items.}

\item{fn_overflow}{Whether to apply \code{fn} to the overflow message when \code{x}
contains more items than \code{max}.
Defaults to \code{FALSE}.}

\item{sep}{The mark to place between list items. Defaults to \code{", "}}

\item{conj}{A conjunction to place between list items. Defaults to \code{"and"}.}

\item{syndeton}{Whether to place the conjunction before the \code{"last"} list
items, between \code{"all"} list items, or between \code{"none"}.
Defaults to \code{"last"}.}

\item{oxford}{A logical value indicating whether to place \code{sep} before the
last list item (x, y, and z) or not (x, y and z) in lists of length three
or more where \code{syndeton} is \code{"last"}.
Defaults to \code{TRUE} if R's locale is set to the United States and \code{FALSE}
otherwise.
The default can be changed by setting \code{options(plu.oxford_comma)}.}
}
\value{
A character vector of length 1
}
\description{
Collapse character vectors into natural language strings
}
\examples{
ingredients <- c("sugar", "spice", "everything nice")
plu::stick(ingredients)

plu::stick(ingredients, fn = toupper)
plu::stick(names(formals(plu::stick)), fn = encodeString, quote = "`")

plu::stick(ingredients, conj = "or")

plu::stick(ingredients, syndeton = "all")

plu::stick(ingredients, sep = "/", syndeton = "none")

creed <- c("snow", "rain", "heat", "gloom of night")
plu::stick(creed, conj = "nor", syndeton = "all")

dedication <- c("my parents", "Ayn Rand", "God")
plu::stick(dedication)
plu::stick(dedication, oxford = TRUE)
plu::stick(dedication, oxford = FALSE)
}
\seealso{
\code{\link[glue:glue_collapse]{glue::glue_collapse()}} for a generalized way to collapse vectors
into a single string
}
