% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plumber-step.R
\name{PlumberEndpoint}
\alias{PlumberEndpoint}
\title{Plumber Endpoint}
\description{
Plumber Endpoint

Plumber Endpoint
}
\details{
Defines a terminal handler in a Plumber router.

Parameters values are obtained from parsing blocks of lines in a plumber file.
They can also be provided manually for historical reasons.
}
\section{Super classes}{
\code{plumber::Hookable} -> \code{plumber::PlumberStep} -> \code{PlumberEndpoint}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{verbs}}{a character vector. http methods. For historical reasons we have
to accept multiple verbs for a single path. Now it's simpler to just parse
each separate verb/path into its own endpoint, so we just do that.}

\item{\code{path}}{a character string. endpoint path}

\item{\code{comments}}{endpoint comments}

\item{\code{description}}{endpoint description}

\item{\code{responses}}{endpoint responses}

\item{\code{params}}{endpoint parameters}

\item{\code{tags}}{endpoint tags}

\item{\code{parsers}}{step allowed parsers}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PlumberEndpoint-getTypedParams}{\code{PlumberEndpoint$getTypedParams()}}
\item \href{#method-PlumberEndpoint-canServe}{\code{PlumberEndpoint$canServe()}}
\item \href{#method-PlumberEndpoint-matchesPath}{\code{PlumberEndpoint$matchesPath()}}
\item \href{#method-PlumberEndpoint-new}{\code{PlumberEndpoint$new()}}
\item \href{#method-PlumberEndpoint-getPathParams}{\code{PlumberEndpoint$getPathParams()}}
\item \href{#method-PlumberEndpoint-getFunc}{\code{PlumberEndpoint$getFunc()}}
\item \href{#method-PlumberEndpoint-getFuncParams}{\code{PlumberEndpoint$getFuncParams()}}
\item \href{#method-PlumberEndpoint-getEndpointParams}{\code{PlumberEndpoint$getEndpointParams()}}
\item \href{#method-PlumberEndpoint-setPath}{\code{PlumberEndpoint$setPath()}}
\item \href{#method-PlumberEndpoint-clone}{\code{PlumberEndpoint$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="plumber" data-topic="Hookable" data-id="registerHooks"><a href='../../plumber/html/Hookable.html#method-Hookable-registerHooks'><code>plumber::Hookable$registerHooks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="PlumberStep" data-id="exec"><a href='../../plumber/html/PlumberStep.html#method-PlumberStep-exec'><code>plumber::PlumberStep$exec()</code></a></span></li>
<li><span class="pkg-link" data-pkg="plumber" data-topic="PlumberStep" data-id="registerHook"><a href='../../plumber/html/PlumberStep.html#method-PlumberStep-registerHook'><code>plumber::PlumberStep$registerHook()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlumberEndpoint-getTypedParams"></a>}}
\if{latex}{\out{\hypertarget{method-PlumberEndpoint-getTypedParams}{}}}
\subsection{Method \code{getTypedParams()}}{
retrieve endpoint typed parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberEndpoint$getTypedParams()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlumberEndpoint-canServe"></a>}}
\if{latex}{\out{\hypertarget{method-PlumberEndpoint-canServe}{}}}
\subsection{Method \code{canServe()}}{
ability to serve request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberEndpoint$canServe(req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req}}{a request object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a logical. \code{TRUE} when endpoint can serve request.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlumberEndpoint-matchesPath"></a>}}
\if{latex}{\out{\hypertarget{method-PlumberEndpoint-matchesPath}{}}}
\subsection{Method \code{matchesPath()}}{
determines if route matches requested path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberEndpoint$matchesPath(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{a url path}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a logical. \code{TRUE} when endpoint matches the requested path.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlumberEndpoint-new"></a>}}
\if{latex}{\out{\hypertarget{method-PlumberEndpoint-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{PlumberEndpoint} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberEndpoint$new(
  verbs,
  path,
  expr,
  envir,
  serializer,
  parsers,
  lines,
  params,
  comments,
  description,
  responses,
  tags,
  srcref
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbs}}{Endpoint verb Ex: \code{"GET"}, \code{"POST"}}

\item{\code{path}}{Endpoint path. Ex: \code{"/index.html"}, \code{"/foo/bar/baz"}}

\item{\code{expr}}{Endpoint function or expression that evaluates to a function.}

\item{\code{envir}}{Endpoint environment}

\item{\code{serializer}}{Endpoint serializer. Ex: \code{\link[=serializer_json]{serializer_json()}}}

\item{\code{parsers}}{Can be one of:
\itemize{
\item A \code{NULL} value
\item A character vector of parser names
\item A named \code{list()} whose keys are parser names names and values are arguments to be applied with \code{\link[=do.call]{do.call()}}
\item A \code{TRUE} value, which will default to combining all parsers. This is great for seeing what is possible, but not great for security purposes
}

If the parser name \code{"all"} is found in any character value or list name, all remaining parsers will be added.
When using a list, parser information already defined will maintain their existing argument values.  All remaining parsers will use their default arguments.

Example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# provide a character string
parsers = "json"

# provide a named list with no arguments
parsers = list(json = list())

# provide a named list with arguments; include `rds`
parsers = list(json = list(simplifyVector = FALSE), rds = list())

# default plumber parsers
parsers = c("json", "form", "text", "octet", "multi")
}\if{html}{\out{</div>}}}

\item{\code{lines}}{Endpoint block}

\item{\code{params}}{Endpoint params}

\item{\code{comments, description, responses, tags}}{Values to be used within the OpenAPI Spec}

\item{\code{srcref}}{\code{srcref} attribute from block}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{PlumberEndpoint} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlumberEndpoint-getPathParams"></a>}}
\if{latex}{\out{\hypertarget{method-PlumberEndpoint-getPathParams}{}}}
\subsection{Method \code{getPathParams()}}{
retrieve endpoint path parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberEndpoint$getPathParams(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{endpoint path}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlumberEndpoint-getFunc"></a>}}
\if{latex}{\out{\hypertarget{method-PlumberEndpoint-getFunc}{}}}
\subsection{Method \code{getFunc()}}{
retrieve endpoint function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberEndpoint$getFunc()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlumberEndpoint-getFuncParams"></a>}}
\if{latex}{\out{\hypertarget{method-PlumberEndpoint-getFuncParams}{}}}
\subsection{Method \code{getFuncParams()}}{
retrieve endpoint expression parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberEndpoint$getFuncParams()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlumberEndpoint-getEndpointParams"></a>}}
\if{latex}{\out{\hypertarget{method-PlumberEndpoint-getEndpointParams}{}}}
\subsection{Method \code{getEndpointParams()}}{
retrieve endpoint defined parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberEndpoint$getEndpointParams()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlumberEndpoint-setPath"></a>}}
\if{latex}{\out{\hypertarget{method-PlumberEndpoint-setPath}{}}}
\subsection{Method \code{setPath()}}{
Updates \verb{$path} with a sanitized \code{path} and updates the internal path meta-data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberEndpoint$setPath(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path to set \verb{$path}. If missing a beginning slash, one will be added.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PlumberEndpoint-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PlumberEndpoint-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PlumberEndpoint$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
