% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singularize.R
\name{singularize}
\alias{singularize}
\title{Singularize a word}
\usage{
singularize(x)
}
\arguments{
\item{x}{vector of words to make singular}
}
\value{
modified character vector of singularized words
}
\description{
If the built-in rules are not sufficient, use \code{add_singular_rule()} to
customize the behavior.
}
\examples{
singularize('test')
singularize(c("boats", "houses", "cats", "rivers"))
pluralize(singularize(c("boats", "houses", "cats", "rivers")))
singularize(c("buses", "wishes", "pitches", "boxexs"))
pluralize(singularize(c("buses", "wishes", "pitches", "boxexs")))
singularize(c("pennies", "spies", "babies", "cities", "daisies"))
pluralize(singularize(c("pennies", "spies", "babies", "cities", "daisies")))
singularize(c("sheep", "fish", "deer", "species", "aircraft"))
pluralize(singularize(c("sheep", "fish", "deer", "species", "aircraft")))
}
