% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqData_wrappers.R
\name{dispersion_est}
\alias{dispersion_est}
\title{Diagnostic plot for seqData}
\usage{
dispersion_est(
  omicsData,
  method,
  interactive = FALSE,
  x_lab = NULL,
  x_lab_size = 11,
  x_lab_angle = NULL,
  y_lab = NULL,
  y_lab_size = 11,
  title_lab = NULL,
  title_lab_size = 14,
  legend_lab = NULL,
  legend_position = "right",
  bw_theme = TRUE,
  palette = NULL,
  point_size = 0.2,
  custom_theme = NULL
)
}
\arguments{
\item{omicsData}{seqData object used to terst dispersions}

\item{method}{either "DESeq2", "edgeR", or "voom" for testing dispersion}

\item{interactive}{Logical. If TRUE produces an interactive plot.}

\item{x_lab}{A character string specifying the x-axis label when the metric
argument is NULL. The default is NULL in which case the x-axis label will
be "count".}

\item{x_lab_size}{An integer value indicating the font size for the x-axis.
The default is 11.}

\item{x_lab_angle}{An integer value indicating the angle of x-axis labels.}

\item{y_lab}{A character string specifying the y-axis label. The default is
NULL in which case the y-axis label will be the metric selected for the
\code{metric} argument.}

\item{y_lab_size}{An integer value indicating the font size for the y-axis.
The default is 11.}

\item{title_lab}{A character string specifying the plot title when the
\code{metric} argument is NULL.}

\item{title_lab_size}{An integer value indicating the font size of the plot
title. The default is 14.}

\item{legend_lab}{A character string specifying the legend title.}

\item{legend_position}{A character string specifying the position of the
legend. Can be one of "right", "left", "top", or "bottom". The default is
"right".}

\item{bw_theme}{Logical. If TRUE uses the ggplot2 black and white theme.}

\item{palette}{A character string indicating the name of the RColorBrewer
palette to use. For a list of available options see the details section in
\code{\link[RColorBrewer]{RColorBrewer}}.}

\item{point_size}{An integer specifying the size of the points. The default
is 0.2.}

\item{custom_theme}{a ggplot `theme` object to be applied to non-interactive
plots, or those converted by plotly::ggplotly().}
}
\value{
plot result
}
\description{
For generating statistics for 'seqData' objects
}
\details{
DESeq2 option requires package "survival" to be available.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(pmartRdata)
myseqData <- group_designation(omicsData = rnaseq_object, main_effects = "Virus")
dispersion_est(omicsData = myseqData, method = "edgeR")
dispersion_est(omicsData = myseqData, method = "DESeq2")
dispersion_est(omicsData = myseqData, method = "voom")
}
\dontshow{\}) # examplesIf}
}
\references{
Robinson MD, McCarthy DJ, Smyth GK (2010). “edgeR: a Bioconductor package
 for differential expression analysis of digital gene expression data.”
 Bioinformatics, 26(1), 139-140. doi: 10.1093/bioinformatics/btp616.

 Love, M.I., Huber, W., Anders, S. Moderated estimation of fold change and
 dispersion for RNA-seq data with DESeq2 Genome Biology 15(12):550 (2014)

 Ritchie, M.E., Phipson, B., Wu, D., Hu, Y., Law, C.W., Shi, W., and Smyth,
 G.K. (2015). limma powers differential expression analyses for
 RNA-sequencing and microarray studies. Nucleic Acids Research 43(7), e47.
}
