% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cases.R
\name{cases_expr_}
\alias{cases_expr_}
\alias{cases_expr}
\title{Create an expression that tests patterns against an expression in turn}
\usage{
cases_expr_(expr, ...)

cases_expr(expr, ...)
}
\arguments{
\item{expr}{The expression to test against. This is usually a bare symbol.}

\item{...}{Pattern matching rules as in \code{\link{cases}}.}
}
\description{
Where \code{\link{cases}} evaluates expressions based on pattern matches, this function
creates a long if-else expression that tests patterns in turn and evaluate the expression
for a matching pattern. This function is intended for meta-programming rather than
usual pattern matching.
}
\section{Functions}{
\itemize{
\item \code{cases_expr_}: Version that expects \code{expr} to be quoted.

\item \code{cases_expr}: Version that quotes \code{expr} itself.
}}

\examples{
linked_list := NIL | CONS(car, cdr : linked_list)

length_body <- cases_expr(lst, NIL -> acc, CONS(car, cdr) -> ll_length(cdr, acc + 1))
length_body

ll_length <- rlang::new_function(alist(lst=, acc = 0), length_body)
ll_length(CONS(1, CONS(2, CONS(3, CONS(4, NIL)))))

}
