% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmd.R
\name{getpaired}
\alias{getpaired}
\title{Filter ions/peaks based on retention time hierarchical clustering, paired mass distances(PMD) and PMD frequency analysis.}
\usage{
getpaired(list, rtcutoff = 10, ng = NULL, digits = 2, accuracy = 4)
}
\arguments{
\item{list}{a list with mzrt profile}

\item{rtcutoff}{cutoff of the distances in retention time hierarchical clustering analysis, default 10}

\item{ng}{cutoff of global PMD's retention time group numbers, default NULL}

\item{digits}{mass or mass to charge ratio accuracy for pmd, default 2}

\item{accuracy}{measured mass or mass to charge ratio in digits, default 4}
}
\value{
list with tentative isotope, multi-chargers, adducts, and neutral loss peaks' index, retention time clusters.
}
\description{
Filter ions/peaks based on retention time hierarchical clustering, paired mass distances(PMD) and PMD frequency analysis.
}
\examples{
data(spmeinvivo)
pmd <- getpaired(spmeinvivo)
}
\seealso{
\code{\link{getstd}},\code{\link{getsda}},\code{\link{plotpaired}}
}
