% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_to_pmml.R
\name{function_to_pmml}
\alias{function_to_pmml}
\title{Convert an R expression to PMML.}
\usage{
function_to_pmml(expr)
}
\arguments{
\item{expr}{An R expression enclosed in quotes.}
}
\value{
PMML version of the input expression
}
\description{
Convert an R expression to PMML.
}
\details{
As long as the expression passed to the function is a valid R expression (e.g., no unbalanced parenthesis),
it can contain arbitrary function names not defined in R. Variables in the expression passed
to `xform_function` are always assumed to be fields, and not substituted. That is, even if `x` has a value in the
R environment, the resulting expression will still use `x`.

An expression such as `foo(x)` is treated as a function `foo` with argument `x`. Consequently, passing in an
R vector `c(1,2,3)` to `function_to_pmml()` will produce PMML where `c` is a function and `1,2,3` are the arguments.

An expression starting with '-' or '+' (for example, "-3" or "-(a+b)") will be treated as if there is a 0
before the initial '-' or '+' sign. This makes it possible to represent expressions that start with a sign,
since PMML's '-' and '+' functions require two arguments. The resulting PMML node will have a constant 0 as a child.
}
\examples{
# Operator precedence and parenthesis
func_pmml <- function_to_pmml("1 + 3/5 - (4 * 2)")

# Nested arbitrary functions
func_pmml <- function_to_pmml("foo(bar(x)) - bar(foo(y-z))")

# If-else expression
func_pmml <- function_to_pmml("if (x==3) { 3 } else { 0 }")

# If-else with boolean output
func_pmml <- function_to_pmml("if (x==3) { TRUE } else { FALSE }")

# Function with string argument types
func_pmml <- function_to_pmml("colors('red','green','blue')")

# Sign in front of expression
func_pmml <- function_to_pmml("-(x/y)")
}
\author{
Dmitriy Bolotov
}
