% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pocket_add.R
\name{pocket_add}
\alias{pocket_add}
\title{pocket_add}
\usage{
pocket_add(
  add_urls,
  item_ids = "",
  tags = NULL,
  success = TRUE,
  consumer_key = Sys.getenv("POCKET_CONSUMER_KEY"),
  access_token = Sys.getenv("POCKET_ACCESS_TOKEN")
)
}
\arguments{
\item{add_urls}{Character vector. The URL or URLs you want to add to your Pocket list.}

\item{item_ids}{Character vector. The item_ids of the items you want to add. Defaults to empty character vector.}

\item{tags}{Character vector. One or more tags to be applied to all of the newly added URLs. Defaults to NULL.}

\item{success}{Logical. Enables success/failure messages for every URL. Defaults to TRUE. Needs GET permission if TRUE.}

\item{consumer_key}{Character string. Your Pocket consumer key. Defaults to \code{Sys.getenv("POCKET_CONSUMER_KEY")}.}

\item{access_token}{Character string. Your Pocket request token. Defaults to \code{Sys.getenv("POCKET_ACCESS_TOKEN")}.}
}
\value{
the response from the httr call, invisibly
}
\description{
Add one or more items to your Pocket account.
}
\details{
This function uses the \code{modify} endpoint of the Pocket API which exhibits some weird behaviour. 
For example, even if a `modify` action is not successful, the API will still return "success". 
See [issue [#26](https://github.com/CorrelAid/pocketapi/issues/26) for a discussion.
}
