% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PopulationResults.R
\name{PopulationResults}
\alias{PopulationResults}
\title{R6 class representing population simulator results.}
\description{
\code{\link[R6:R6Class]{R6}} class encapsulating and dynamically generating
spatially-explicit \code{\link{population_simulator}} results, as well as optional
re-generated \code{\link{Generator}} outputs.
}
\examples{
# U Island example region
coordinates <- data.frame(x = rep(seq(177.01, 177.05, 0.01), 5),
                          y = rep(seq(-18.01, -18.05, -0.01), each = 5))
template_raster <- Region$new(coordinates = coordinates)$region_raster # full extent
template_raster[][-c(7, 9, 12, 14, 17:19)] <- NA # make U Island
region <- Region$new(template_raster = template_raster)
raster::plot(region$region_raster, main = "Example region (indices)",
             xlab = "Longitude (degrees)", ylab = "Latitude (degrees)",
             colNA = "blue")
# Sample results occupancy (ignore cell 2 in last 5 time steps)
occupancy_raster <- region$raster_from_values(array(1, c(7, 13)))
occupancy_raster[region$region_indices][2, 9:13] <- 0
occupancy_raster[region$region_indices]
# Population simulation example results
example_results <- list(abundance = t(apply(matrix(11:17), 1, function(n)  {
  c(rep(n, 3), round(n*exp(-(0:9)/2)))}
)))
example_results$harvested <- round(example_results$abundance*0.3)
example_results
# Population results object
pop_results <- PopulationResults$new(region = region,
                                     time_steps = 13,
                                     burn_in_steps = 3,
                                     occupancy_mask = occupancy_raster,
                                     trend_interval = 1:5)
pop_results$get_attribute_names(all = TRUE)
# Clone (for each population simulation results)
results_clone <- pop_results$new_clone(results = example_results)
results_clone$all$get_attribute("abundance")
results_clone$get_attributes(c("abundance", "all$abundance",
                               "abundance_trend", "all$abundance_trend",
                               "all$ema", # only defined for all
                               "extirpation", "all$extirpation",
                               "all$extinction_location", # only defined for all
                               "harvested", "all$harvested",
                               "occupancy", "all$occupancy"))

}
\section{Super classes}{
\code{\link[poems:GenericClass]{poems::GenericClass}} -> \code{\link[poems:GenericModel]{poems::GenericModel}} -> \code{\link[poems:SpatialModel]{poems::SpatialModel}} -> \code{\link[poems:SimulationResults]{poems::SimulationResults}} -> \code{PopulationResults}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{model_attributes}}{A vector of model attribute names.}

\item{\code{region}}{A \code{\link{Region}} (or inherited class) object specifying the study region.}

\item{\code{coordinates}}{Data frame (or matrix) of X-Y population (WGS84) coordinates in longitude (degrees West) and latitude (degrees North) (get and set), or distance-based coordinates dynamically returned by region raster (get only).}

\item{\code{time_steps}}{Number of simulation time steps.}

\item{\code{burn_in_steps}}{Optional number of initial 'burn-in' time steps to be ignored.}

\item{\code{occupancy_mask}}{Optional binary mask array (matrix), data frame, or raster (stack) for each cell at each time-step of the simulation including burn-in.}

\item{\code{trend_interval}}{Optional time-step range (indices) for trend calculations (assumes indices begin after the burn-in when utilized).}

\item{\code{abundance}}{Population abundance across simulation time-steps (summary list or replicate array).}

\item{\code{abundance_stages}}{Population abundance for combined stages across simulation time-steps (list of summary lists or replicate arrays for each combined stage).}

\item{\code{abundance_trend}}{Trend or average Sen's \code{\link[trend:sens.slope]{slope}} of abundance (optionally across a time-step interval).}

\item{\code{ema}}{Array of population expected minimum abundance (EMA) across simulation time-steps.}

\item{\code{extirpation}}{Array of population extirpation times.}

\item{\code{extinction_location}}{The weighted centroid of cells occupied in the time-step prior to the extirpation of all populations (if it occurred).}

\item{\code{harvested}}{Number of animals harvested from each population across simulation time-steps (summary list or replicate array).}

\item{\code{harvested_stages}}{Number of animals harvested from each population for combined stages across simulation time-steps (list of summary lists or replicate arrays for each combined stage).}

\item{\code{occupancy}}{Array of the number of populations occupied at each time-step.}

\item{\code{all}}{Nested simulation results for all cells.}

\item{\code{parent}}{Parent simulation results for individual cells.}

\item{\code{default}}{Default value/attribute utilized when applying primitive metric functions (e.g. max) to the results.}

\item{\code{attribute_aliases}}{A list of alternative alias names for model attributes (form: \code{alias = "attribute"}) to be used with the set and get attributes methods.}

\item{\code{error_messages}}{A vector of error messages encountered when setting model attributes.}

\item{\code{warning_messages}}{A vector of warning messages encountered when setting model attributes.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-clone}{\code{PopulationResults$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute">}\href{../../poems/html/GenericModel.html#method-get_attribute}{\code{poems::GenericModel$get_attribute()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute_aliases">}\href{../../poems/html/GenericModel.html#method-get_attribute_aliases}{\code{poems::GenericModel$get_attribute_aliases()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="SimulationResults" data-id="get_attribute_names">}\href{../../poems/html/SimulationResults.html#method-get_attribute_names}{\code{poems::SimulationResults$get_attribute_names()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="SimulationResults" data-id="get_attributes">}\href{../../poems/html/SimulationResults.html#method-get_attributes}{\code{poems::SimulationResults$get_attributes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="SimulationResults" data-id="initialize">}\href{../../poems/html/SimulationResults.html#method-initialize}{\code{poems::SimulationResults$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="SimulationResults" data-id="new_clone">}\href{../../poems/html/SimulationResults.html#method-new_clone}{\code{poems::SimulationResults$new_clone()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="SimulationResults" data-id="set_attributes">}\href{../../poems/html/SimulationResults.html#method-set_attributes}{\code{poems::SimulationResults$set_attributes()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PopulationResults$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
