% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pointer.rgc.R
\name{pointer.rgc}
\alias{pointer.rgc}
\title{Calculate pointer years using the relative growth change method}
\usage{
pointer.rgc(data, nb.yrs = 4, rgc.thresh.pos = 60, rgc.thresh.neg = 40,
            series.thresh = 75)
}
\arguments{
\item{data}{a \code{data.frame} with tree-ring series as columns and years as rows (e.g., output of \code{read.rwl} of package dplR)}

\item{nb.yrs}{an \code{integer} specifying the number of preceding years to be used in calculating relative growth changes. Defaults to 4.}

\item{rgc.thresh.pos}{a \code{numeric} specifying the threshold above which a relative growth change (in percentage) for a specific tree and year is considered a positive event year. Defaults to 60.}

\item{rgc.thresh.neg}{a \code{numeric} specifying the threshold below which a relative growth change (in percentage) for a specific tree and year is considered a negative event year. Defaults to 40.}

\item{series.thresh}{a \code{numeric} specifying the minimum percentage of trees that should display a positive (or negative) event year for that year to be considered as positive (or negative) pointer year. Defaults to 75.}
}
\value{
The function returns a \code{list} containing the following components:
\item{rgc}{a \code{matrix} with relative growth changes for individual tree-ring series}
\item{EYvalues}{a \code{matrix} indicating positive (1), negative (-1) and non-event years (0) for individual tree-ring series}
\item{out}{a \code{data.frame} containing the following columns:}
\item{}{\code{year} - time stamp}
\item{}{\code{nb.series} - number of series considered}
\item{}{\code{perc.pos} - percentage of trees showing a positive event year}
\item{}{\code{perc.neg} - percentage of trees showing a negative event year}
\item{}{\code{nature} - number indicating whether the year is a positive (1), negative (-1) or no pointer year (0)}
\item{}{\code{dev_mean} - mean growth deviation in percentage over the available series}
\item{}{\code{dev_sd} - standard deviation of the growth deviation}
\item{spec.param}{a \code{data.frame} specifying the arguments used in the calculation}
}
\description{
The function calculates pointer years on a \code{data.frame} of tree-ring series using the relative (or abrupt) growth change method as described in Schweingruber et al. (1990). This method relates tree growth in year \code{\var{i}} to the average growth of \code{\var{n}} preceding years. Thresholds for event- and pointer-year calculations can be adjusted.
}
\details{
The function relates tree growth in year \code{\var{i}} to the average growth of \code{\var{n}} preceding years for individual trees. Resulting relative growth changes are used to identify event years for trees, and these event years to define pointer years for the site.

Following Schweingruber et al. (1990), \code{\var{nb.yrs}}, \code{\var{rgc.thresh.pos}}, \code{\var{rgc.thresh.neg}} and \code{\var{series.thresh}} are set to 4, 60, 40 and 75 respectively, meaning that a positive or negative pointer year will be defined when at least 75\% of the tree-ring series display an event year with a growth increase or decrease of at least 60 or 40\%, respectively, relative to the average growth in the 4 preceding years.

Note that the resulting time series are truncated by \code{\var{nb.yrs}} at the beginning inherent to the calculation methods.
}
\examples{
## Calculate pointer years on tree-ring series
data(s033)
py <- pointer.rgc(s033, nb.yrs = 4, rgc.thresh.pos = 60, rgc.thresh.neg = 40,
                  series.thresh = 75)
py$out
}
\author{
Marieke van der Maaten-Theunissen and Ernst van der Maaten.
}
\references{
Schweingruber, F.H., Eckstein, D., Serre-Bachet, F. and Bräker, O.U. (1990) Identification, presentation and interpretation of event years and pointer years in dendrochronology. \emph{Dendrochronologia} 8: 9-38.

In writing the function, the code of the dplR function \code{pointer} (Pierre Mérian) was used as a reference.
}

