% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_agent.R
\name{create_agent}
\alias{create_agent}
\title{Create a pointblank agent object}
\usage{
create_agent(tbl, name = NULL)
}
\arguments{
\item{tbl}{The input table that will be the focus of the validation. This can
be a data frame, a tibble, or a \code{tbl_dbi} object.}

\item{name}{An optional name for the validation plan that the agent will
eventually carry out during the interrogation process. If no value is
provided, a name will be generated based on the current system time.}
}
\value{
A \code{ptblank_agent} object.
}
\description{
Creates an agent object.
}
\section{Function ID}{

1-1
}

\examples{
library(dplyr)

# Create a simple table with a
# column of numerical values
tbl <- tibble(a = c(5, 7, 8, 7))

# Create a pointblank `agent` object
agent <- create_agent(tbl = tbl)

# Then, as with any `ptblank_agent`
# object, we can add validation steps
# to the validation plan and then
# eventually use `interrogate()`
# to perform the validations; here,
# with a single validation step, we
# expect that values in column `a`
# are always greater than 4
agent <-
  agent \%>\%
  col_vals_gt(vars(a), 4) \%>\%
  interrogate()
 
# Get a tibble-based report from the
# agent by using `get_agent_report()`
agent \%>\%
  get_agent_report(display_table = FALSE)

}
\concept{Create an Agent}
