% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_reg.R
\name{poisson_reg}
\alias{poisson_reg}
\alias{update.poisson_reg}
\title{General Interface for Poisson Regression Models}
\usage{
poisson_reg(mode = "regression", penalty = NULL, mixture = NULL)

\method{update}{poisson_reg}(
  object,
  parameters = NULL,
  penalty = NULL,
  mixture = NULL,
  fresh = FALSE,
  ...
)
}
\arguments{
\item{mode}{A single character string for the type of model.
The only possible value for this model is "regression".}

\item{penalty}{A non-negative number representing the total
amount of regularization (\code{glmnet} only).}

\item{mixture}{A number between zero and one (inclusive) that
represents the proportion of regularization that is used for the
L2 penalty (i.e. weight decay, or ridge regression) versus L1
(the lasso) (\code{glmnet} only).}

\item{object}{A boosted tree model specification.}

\item{parameters}{A 1-row tibble or named list with \emph{main}
parameters to update. If the individual arguments are used,
these will supersede the values in \code{parameters}. Also, using
engine arguments in this object will result in an error.}

\item{fresh}{A logical for whether the arguments should be
modified in-place of or replaced wholesale.}

\item{...}{Not used for \code{update()}.}
}
\value{
An updated model specification.
}
\description{
\code{poisson_reg()} is a way to generate a \emph{specification} of a model
before fitting and allows the model to be created using
different packages in R or Stan. The main
arguments for the model are:
\itemize{
\item \code{penalty}: The total amount of regularization
in the model. Note that this must be zero for some engines.
\item \code{mixture}: The proportion of L1 regularization in
the model. Note that this will be ignored for some engines.
}
These arguments are converted to their specific names at the
time that the model is fit. Other options and argument can be
set using \code{set_engine()}. If left to their defaults
here (\code{NULL}), the values are taken from the underlying model
functions. If parameters need to be modified, \code{update()} can be used
in lieu of recreating the object from scratch.
}
\details{
The data given to the function are not saved and are only used
to determine the \emph{mode} of the model. For \code{poisson_reg()}, the
mode will always be "regression".

The model can be created using the \code{fit()} function using the
following \emph{engines}:
\itemize{
\item \pkg{R}:  \code{"glm"}  (the default), \code{"glmnet"}, \code{"hurdle"}, or \code{"zeroinfl"}
\item \pkg{Stan}:  \code{"stan"}
}
}
\section{Engine Details}{
Engines may have pre-set default arguments when executing the model fit
call. For this type of model, the template of the fit calls are:\if{html}{\out{<div class="r">}}\preformatted{poisson_reg() \%>\% 
  set_engine("glm") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Poisson Regression Model Specification (regression)
## 
## Computational engine: glm 
## 
## Model fit template:
## stats::glm(formula = missing_arg(), data = missing_arg(), weights = missing_arg(), 
##     family = stats::poisson)
}\if{html}{\out{<div class="r">}}\preformatted{poisson_reg() \%>\% 
  set_engine("zeroinfl") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Poisson Regression Model Specification (regression)
## 
## Computational engine: zeroinfl 
## 
## Model fit template:
## pscl::zeroinfl(formula = missing_arg(), data = missing_arg(), 
##     weights = missing_arg())
}\if{html}{\out{<div class="r">}}\preformatted{poisson_reg() \%>\% 
  set_engine("hurdle") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Poisson Regression Model Specification (regression)
## 
## Computational engine: hurdle 
## 
## Model fit template:
## pscl::hurdle(formula = missing_arg(), data = missing_arg(), weights = missing_arg())
}\if{html}{\out{<div class="r">}}\preformatted{poisson_reg() \%>\% 
  set_engine("glmnet") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Poisson Regression Model Specification (regression)
## 
## Computational engine: glmnet 
## 
## Model fit template:
## glmnet::glmnet(x = missing_arg(), y = missing_arg(), weights = missing_arg(), 
##     family = "poisson")
}\if{html}{\out{<div class="r">}}\preformatted{poisson_reg() \%>\% 
  set_engine("stan") \%>\% 
  translate()
}\if{html}{\out{</div>}}\preformatted{## Poisson Regression Model Specification (regression)
## 
## Computational engine: stan 
## 
## Model fit template:
## rstanarm::stan_glm(formula = missing_arg(), data = missing_arg(), 
##     weights = missing_arg(), family = stats::poisson)
}

The standardized parameter names in parsnip can be mapped to their
original names in each engine that has main parameters:\tabular{ll}{
   \strong{parsnip} \tab \strong{glmnet} \cr
   penalty \tab lambda \cr
   mixture \tab alpha \cr
}
}

\examples{
poisson_reg()

# Model from Agresti (2007) Table 7.6
log_lin_mod <-
  poisson_reg() \%>\%
  set_engine("glm") \%>\%
  fit(count ~ (.)^2, data = seniors)

summary(log_lin_mod$fit)

# ------------------------------------------------------------------------------

library(pscl)

data("bioChemists", package = "pscl")

poisson_reg() \%>\%
  set_engine("hurdle") \%>\%
# Extended formula:
  fit(art ~ . | phd, data = bioChemists)

model <- poisson_reg(penalty = 10, mixture = 0.1)
model
update(model, penalty = 1)
update(model, penalty = 1, fresh = TRUE)
}
