% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__datetime.R
\name{ExprDT_replace_time_zone}
\alias{ExprDT_replace_time_zone}
\alias{(Expr)$dt$replace_time_zone}
\title{replace_time_zone}
\format{
function
}
\arguments{
\item{tz}{NULL or string time zone from \code{\link[base:timezones]{base::OlsonNames()}}}

\item{use_earliest}{NULL or logical.
If localizing an ambiguous datetime (say, due to daylight saving time),
determine whether to localize to the earliest datetime or not.
If NULL (the default), then ambiguous datetimes will raise.}
}
\value{
Expr of i64
}
\description{
Cast time zone for a Series of type Datetime.
Different from \code{convert_time_zone}, this will also modify the underlying timestamp.
Use to correct a wrong time zone annotation. This will change the corresponding global timepoint.
}
\examples{
df_1 = pl$DataFrame(x = as.POSIXct("2009-08-07 00:00:01", tz = "America/New_York"))

df_1$with_columns(
  pl$col("x")$dt$replace_time_zone("UTC")$alias("utc"),
  pl$col("x")$dt$replace_time_zone("Europe/Amsterdam")$alias("cest")
)

# You can use use_earliest to deal with ambiguous datetimes
df_2 = pl$DataFrame(
  x = seq(
    as.POSIXct("2018-10-28 01:30", tz = "UTC"),
    as.POSIXct("2018-10-28 02:30", tz = "UTC"),
    by = "30 min"
  )
)

df_2$with_columns(
  pl$col("x")$dt$replace_time_zone("Europe/Brussels", TRUE)$alias("use_earliest_true"),
  pl$col("x")$dt$replace_time_zone("Europe/Brussels", FALSE)$alias("use_earliest_false")
)
}
\keyword{ExprDT}
