% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__expr.R
\name{Expr_sample}
\alias{Expr_sample}
\alias{sample}
\title{Sample}
\usage{
Expr_sample(
  frac = NULL,
  with_replacement = TRUE,
  shuffle = FALSE,
  seed = NULL,
  n = NULL
)
}
\arguments{
\item{frac}{Fraction of items to return. Cannot be used with \code{n}.}

\item{with_replacement}{Allow values to be sampled more than once.}

\item{shuffle}{Shuffle the order of sampled data points. (implicitly TRUE if, with_replacement = TRUE)}

\item{seed}{Seed for the random number generator. If set to None (default), a random
seed is used.}

\item{n}{Number of items to return. Cannot be used with \code{frac}.}
}
\value{
Expr
}
\description{
#' Sample from this expression.
}
\examples{
df = pl$DataFrame(a = 1:3)
df$select(pl$col("a")$sample(frac = 1, with_replacement = TRUE, seed = 1L))

df$select(pl$col("a")$sample(frac = 2, with_replacement = TRUE, seed = 1L))

df$select(pl$col("a")$sample(n = 2, with_replacement = FALSE, seed = 1L))
}
\keyword{Expr}
