% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{make_tree}
\alias{make_tree}
\title{A utility function for generating random trees for test purposes.}
\usage{
make_tree(X, depth, d)
}
\arguments{
\item{X}{data matrix.}

\item{depth}{tree depth.}

\item{d}{number of actions.}
}
\value{
A policy_tree tree object
}
\description{
Build a depth \code{depth} tree by drawing random split variables
and split values from the Nxp matrix \code{X}. In leaf nodes a random
action is drawn from 1:\code{d}. (Minimum leaf size will be 1)
}
\examples{
\dontrun{
depth <- 2
n <- 100
p <- 10
d <- 3
X <- matrix(rnorm(n * p), n, p)
Y <- matrix(rnorm(n * d), n, d)
tree <- make_tree(X, depth = depth, d = d)
pp <- predict_test_tree(tree, X)
}
}
\keyword{internal}
