% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cap_get_mip.R
\name{cap_get_mip}
\alias{cap_get_mip}
\title{Download the Comparative Agenda Project's dataset of responses to Gallup's Most Important Problem question, coded by CAP major topic}
\usage{
cap_get_mip(min_year = NULL, max_year = NULL)
}
\arguments{
\item{min_year}{Returns data starting at this year}

\item{max_year}{Returns data up to this year}
}
\value{
a data.frame of CAP's most important problem data
}
\description{
From CAP:
> This dataset contains responses to Gallup's Most Important Problem question aggregated at the annual level and coded by major topic. Years with missing observations (1953/1955) are those in which there were no corresponding MIP data available. Contact us for quarterly MIP data if needed.
}
\examples{


# pull the Most Important Problem data for every year since 1980
mip <- cap_get_mip(min_year = 1980)

# pull the MIP data for every year between 1950 and 1970
mip <- cap_get_mip(min_year = 1950, max_year = 1970)

# pull the MIP Data for every year until 2010
mip <- cap_get_mip(max_year = 2010)


}
\seealso{
The master codebook and datasets at https://www.comparativeagendas.net/datasets_codebooks
}
