% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_def.R
\docType{class}
\name{policy}
\alias{policy}
\title{Policy-class}
\value{
\link{data.table} with keys \code{id} and \code{stage} and
action variable \code{d}.
}
\description{
A function of inherited class "policy" takes a policy
data object as input and returns the policy actions for every observation
for every (observed) stage.
}
\details{
A policy can either be defined directly by the user using
\link{policy_def} or a policy can be fitted using \link{policy_learn}
(or \link{policy_eval}). \link{policy_learn} returns a \link{policy_object} from which
the policy can be extracted using \link{get_policy}.
}
\section{S3 generics}{

The following S3 generic functions are available for an object of class
\code{policy}:
\itemize{
\item{\code{print}}{Baisc print function}
}
}

\examples{
### Two stages:
source(system.file("sim", "two_stage.R", package="polle"))
d <- sim_two_stage(5e2, seed=1)
pd <- policy_data(d,
                  action = c("A_1", "A_2"),
                  covariates = list(L = c("L_1", "L_2"),
                                    C = c("C_1", "C_2")),
                  utility = c("U_1", "U_2", "U_3"))

# defining a dynamic policy:
p <- policy_def(
  dynamic_policy(function(L) (L > 0) * 1),
  reuse = TRUE
)
p
head(p(pd), 5)

# V-restricted (Doubly Robust) Q-learning:
# specifying the learner:
pl <- policy_learn(type = "rqvl",
                   qv_models = q_glm(formula = ~ C))

# fitting the policy (object):
po <- pl(policy_data = pd,
         q_models = q_glm(),
         g_models = g_glm())

p <- get_policy(po)
p

head(p(pd))

}
