% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.speeches_method.R
\docType{methods}
\name{as.speeches}
\alias{as.speeches}
\alias{as.speeches,partition-method}
\title{Split partition into speeches}
\usage{
\S4method{as.speeches}{partition}(.Object, sAttributeDates, sAttributeNames,
  gap = 500, mc = FALSE, verbose = TRUE, progress = TRUE)
}
\arguments{
\item{.Object}{a partition .Object}

\item{sAttributeDates}{the s-attribute that provides the dates of sessions}

\item{sAttributeNames}{the s-attribute that provides the names of speakers}

\item{gap}{number of tokens between strucs to identify speeches}

\item{mc}{whether to use multicore, defaults to FALSE}

\item{verbose}{logical, defaults to TRUE}

\item{progress}{logical}
}
\value{
a partitionBundle object
}
\description{
A method designed for corpora from the
PolMine corpora of plenary protocols. A partition is split into speeches.
}
\examples{
if (require("polmineR.sampleCorpus")){
  use(polmineR.sampleCorpus)
  bt <- partition("PLPRBTTXT", text_year="2009")
  speeches <- as.speeches(bt, sAttributeDates="text_date", sAttributeNames="text_name")
  
  # step-by-step, not the fastest way
  speeches <- enrich(speeches, pAttribute="word")
  tdm <- as.TermDocumentMatrix(speeches, col="count")
  
  # fast option (counts performed when assembling the sparse matrix)
  tdm <- as.TermDocumentMatrix(speeches, pAttribute="word")
  termsToDropList <- noise(tdm)
  whatToDrop <- c("stopwords", "specialChars", "numbers", "minNchar")
  termsToDrop <- unlist(lapply(whatToDrop, function(x) termsToDropList[[x]]))
  tdm <- trim(tdm, termsToDrop = termsToDrop)
}
}

