% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegistryFile.R
\docType{class}
\name{RegistryFile-class}
\alias{RegistryFile}
\alias{RegistryFile-class}
\title{Read, parse and modify registry file.}
\arguments{
\item{corpus}{name of the CWB corpus}

\item{new}{a new value to set}

\item{filename}{a filename}

\item{package}{name of a package}

\item{registry}{directory of the registry (defaults to CORPUS_Registry environment variable)}
}
\description{
Read, parse and modify registry file.
}
\section{Fields}{

\describe{
\item{\code{registryDir}}{registry directory}

\item{\code{encoding}}{corpus encoding}

\item{\code{txt}}{registry as character vector}

\item{\code{pAttributes}}{p-attributes}

\item{\code{properties}}{corpus properties}

\item{\code{id}}{corpus id}

\item{\code{home}}{home directory}

\item{\code{name}}{corpus name}

\item{\code{info}}{path to info file}
}}
\section{Methods}{

\describe{
\item{\code{getEncoding()}}{Get the encoding.}

\item{\code{getHome()}}{Get the home directory of a corpus.}

\item{\code{getId()}}{Get the id of a corpus.}

\item{\code{getInfo()}}{Get path to the info file.}

\item{\code{getName()}}{Get the name of a corpus.}

\item{\code{getPAttributes()}}{Get the pAttributes.}

\item{\code{getProperties()}}{Get corpus properties.}

\item{\code{getSAttributes()}}{Get the sAttributes.}

\item{\code{initialize(corpus = NULL, registry = Sys.getenv("CORPUS_REGISTRY"),
  package = NULL, filename = NULL)}}{Initialize a new RegistryFile object.}

\item{\code{parse()}}{Parse the registry file.}

\item{\code{read()}}{Read file from disc, as character vector in field 'txt'.}
}}

