% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terms.R
\docType{methods}
\name{terms}
\alias{terms}
\alias{terms,partition-method}
\alias{terms,character-method}
\title{Get terms in \code{partition} or corpus.}
\usage{
\S4method{terms}{partition}(x, p_attribute, regex = NULL, ...)

\S4method{terms}{character}(x, p_attribute, regex = NULL, robust = FALSE,
  ...)
}
\arguments{
\item{x}{an atomic \code{character} vector with a corpus id or \code{partition} object}

\item{p_attribute}{the p-attribute to be analyzed}

\item{regex}{regular expression(s) to filter results}

\item{...}{for backward compatibility}

\item{robust}{logical, whether to check for potential failures}
}
\description{
Get terms in \code{partition} or corpus.
}
\examples{
use("polmineR")
session <- partition("GERMAPARLMINI", date = "2009-10-27")
words <- terms(session, "word")
terms(session, p_attribute = "word", regex = "^Arbeit.*")
terms(session, p_attribute = "word", regex = c("Arbeit.*", ".*arbeit"))

terms("GERMAPARLMINI", p_attribute = "word")
terms("GERMAPARLMINI", p_attribute = "word", regex = "^Arbeit.*")
}
