% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triang_interpolation.R
\name{triang_Interpolation}
\alias{triang_Interpolation}
\title{Triangularization of a polynomial matrix by interpolation method}
\usage{
triang_Interpolation(
  pm,
  point_vector,
  round_digits = 5,
  eps = .Machine$double.eps^0.5
)
}
\arguments{
\item{pm}{source polynimial matrix}

\item{point_vector}{vector of interpolation points}

\item{round_digits}{we will try to round result on each step}

\item{eps}{calculation zero errors}
}
\value{
Tranfortmaiton matrix
}
\description{
The parameters `point_vector`, `round_digits` can significantly affect the result.
}
\details{
Default value of `eps`` usually is enought to determintate real zeros.

In a polynomial matrix the head elements are the first non-zero polynomials of columns.
The sequence of row indices of this head elements form the shape of the polynomial matrix.
A polynomial matrix is in left-lower triangular form, if this sequence is monoton increasing.

This method offers a solution of the triangulrization by the Interpolation method,
described in the article of Labhalla-Lombardi-Marlin (1996).
}
\examples{
A <- polyMgen.d(3,2,ch2pn(c("x-1","2","0","x^2-1","2*x+2","3")))

triang_Interpolation(A, -2:2)
# 0.79057 - 0.31623*x + 0.15812*x^2   -0.57735 - 0.57735*x
# 0.47434 - 0.15811*x - 1e-05*x^2     0.57735

triang_Interpolation(A, -10:10)
# 0.79057 - 0.3161*x + 0.15803*x^2   0.25574 - 0.3541*x - 0.60984*x^2
# 0.47448 - 0.15807*x                -0.25574 + 0.60984*x
}
