% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplers.R
\name{r_vmf_polysph}
\alias{r_vmf_polysph}
\title{Sample von Mises--Fisher distributed polyspherical data}
\usage{
r_vmf_polysph(n, d, mu, kappa, norm_mu = FALSE)
}
\arguments{
\item{n}{sample size.}

\item{d}{vector of size \code{r} with dimensions.}

\item{mu}{a vector of size \code{sum(d) + r} with the concatenated von
Mises--Fisher means.}

\item{kappa}{a vector of size \code{r} with the von Mises--Fisher
concentrations.}

\item{norm_mu}{ensure a normalization of \code{mu}? Defaults to \code{FALSE}.}
}
\value{
A matrix of size \code{c(n, sum(d) + r)} with the sample.
}
\description{
Simulates from a product of von Mises--Fisher distributions on
the polysphere \eqn{\mathcal{S}^{d_1} \times \cdots \times
\mathcal{S}^{d_r}}.
}
\examples{
# Simulate vMF data on (S^1)^2
r_vmf_polysph(n = 10, d = c(1, 1), mu = c(1, 0, 0, 1), kappa = c(1, 1))
}
