% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{assign_SN_SN}
\alias{assign_SN_SN}
\title{Assign (leftover) 1.0 markers}
\usage{
assign_SN_SN(linkage_df, LG_hom_stack, LOD_threshold, ploidy, LG_number,
  log = NULL)
}
\arguments{
\item{linkage_df}{A \code{data.frame} as output of \code{\link{linkage}} with arguments markertype1=c(1,0) and markertype2=NULL.}

\item{LG_hom_stack}{A \code{data.frame} with markernames (\code{"SxN_Marker"}), linkage group (\code{"LG"}) and homologue (\code{"homologue"})}

\item{LOD_threshold}{A LOD score at which linkages between markers are significant.}

\item{ploidy}{Integer. The ploidy level of the plant species.}

\item{LG_number}{Integer. Number of chromosomes (linkage groups)}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}
}
\value{
Returns a \code{data.frame} with the following columns:
\item{SxN_Marker}{The markername}
\item{Assigned_hom1}{The assigned homologue}
\item{Assigned_LG}{The assigned linkage group}
}
\description{
Some 1.0 markers might have had ambiguous linkages, or linkages with low LOD scores leaving them unlinked to a linkage group.
\code{assign_SN_SN} finds 1.0 markers unlinked to a linkage group and tries to assign them.
}
\examples{
data("SN_SN_P1", "LGHomDf_P1_1")
SN_assigned<-assign_SN_SN(linkage_df = SN_SN_P1,
             LG_hom_stack = LGHomDf_P1_1,
             LOD_threshold= 4,
             ploidy=4,
             LG_number=5)
}
